# Panduan Perbaikan Basic Authentication untuk API Baden

## Masalah
Anda mendapatkan error "401 Unauthorized - Invalid Basic Authentication credentials" saat mengakses endpoint `https://copilotproduction.site/api/in/baden`.

## Penyebab
Receiver "baden" di database belum dikonfigurasi dengan Basic Authentication yang benar.

## Solusi

### Langkah 1: Update Receiver di Database

1. Upload file `update_baden_receiver.php` ke hosting Anda
2. Jalankan file tersebut melalui browser atau SSH:
   ```
   https://copilotproduction.site/update_baden_receiver.php
   ```

### Langkah 2: Verifikasi Konfigurasi

Setelah menjalankan update, receiver akan dikonfigurasi dengan:
- **Endpoint**: `/api/in/baden`
- **Auth Type**: `basic_auth`
- **Username**: `baden`
- **Password**: `baden`
- **Authorization Header**: `Basic YmFkZW46YmFkZW4=`

### Langkah 3: Test Basic Auth

1. Upload file `test_basic_auth_fixed.php` ke hosting
2. Jalankan test untuk memverifikasi:
   ```
   https://copilotproduction.site/test_basic_auth_fixed.php
   ```

### Langkah 4: Gunakan di API Client

#### Di Postman/Insomnia:
- **URL**: `https://copilotproduction.site/api/in/baden`
- **Method**: `POST`
- **Auth Type**: `Basic Auth`
- **Username**: `baden`
- **Password**: `baden`

#### Di cURL:
```bash
curl -X POST https://copilotproduction.site/api/in/baden \
  -H "Authorization: Basic YmFkZW46YmFkZW4=" \
  -H "Content-Type: application/json" \
  -d '{
    "order_id": "TEST-123",
    "customer_name": "John Doe",
    "total_amount": 100.50
  }'
```

#### Di JavaScript/Fetch:
```javascript
fetch('https://copilotproduction.site/api/in/baden', {
  method: 'POST',
  headers: {
    'Authorization': 'Basic YmFkZW46YmFkZW4=',
    'Content-Type': 'application/json'
  },
  body: JSON.stringify({
    order_id: 'TEST-123',
    customer_name: 'John Doe',
    total_amount: 100.50
  })
})
.then(response => response.json())
.then(data => console.log(data));
```

## Troubleshooting

### Jika masih mendapat error 401:
1. Periksa apakah receiver sudah diupdate dengan benar
2. Pastikan username dan password adalah "baden" (tanpa tanda kutip)
3. Pastikan Authorization header menggunakan format yang benar: `Basic YmFkZW46YmFkZW4=`

### Jika mendapat error 404:
1. Pastikan endpoint `/api/in/baden` sudah terdaftar di routes
2. Periksa apakah receiver aktif di database

### Jika mendapat error 500:
1. Periksa log error di hosting
2. Pastikan database connection berfungsi
3. Periksa apakah semua migration sudah dijalankan

## Informasi Debug

Kode sudah ditambahkan logging untuk debug di `app/Http/Controllers/ApiReceiverController.php`. Log akan menampilkan:
- Header Authorization yang diterima
- Username dan password yang disimpan di database
- Perbandingan credentials
- Status autentikasi

## Support

Jika masih mengalami masalah, periksa:
1. Log error di hosting
2. Status receiver di dashboard admin
3. Konfigurasi database
