# Format Response GET Request

## ✅ **Response GET yang Sudah Diperbaiki**

### **1. GET Request Normal**
```bash
curl -X GET "https://your-domain.com/api/in/ujicoba"
```

**Response:**
```json
{
    "success": true,
    "message": "Data retrieved successfully",
    "received_at": "2025-08-08T02:57:15.314077Z",
    "data": [
        {
            "id": 1,
            "external_id": 123,
            "nama": "John Doe",
            "alamat": "Jakarta",
            "gender": "male",
            "data": "{\"key\": \"value\"}",
            "created_at": "2025-08-08T02:55:26.000000Z",
            "updated_at": "2025-08-08T02:55:26.000000Z"
        },
        {
            "id": 2,
            "external_id": 456,
            "nama": "Jane Smith",
            "alamat": "Bandung",
            "gender": "female",
            "data": "{\"key\": \"value2\"}",
            "created_at": "2025-08-08T02:56:00.000000Z",
            "updated_at": "2025-08-08T02:56:00.000000Z"
        }
    ],
    "total_records": 2
}
```

### **2. GET Request dengan Pagination**
```bash
curl -X GET "https://your-domain.com/api/in/ujicoba?limit=5&offset=0&sort=id&order=desc"
```

**Response:**
```json
{
    "success": true,
    "message": "Data retrieved successfully",
    "received_at": "2025-08-08T02:57:15.314077Z",
    "data": [
        {
            "id": 15,
            "external_id": 999,
            "nama": "Latest Record",
            "alamat": "Surabaya",
            "gender": "male",
            "data": "{\"key\": \"latest\"}",
            "created_at": "2025-08-08T02:57:00.000000Z",
            "updated_at": "2025-08-08T02:57:00.000000Z"
        }
    ],
    "total_records": 1
}
```

### **3. GET Request dengan Filter**
```bash
curl -X GET "https://your-domain.com/api/in/ujicoba?nama=John&gender=male"
```

**Response:**
```json
{
    "success": true,
    "message": "Data retrieved successfully",
    "received_at": "2025-08-08T02:57:15.314077Z",
    "data": [
        {
            "id": 1,
            "external_id": 123,
            "nama": "John Doe",
            "alamat": "Jakarta",
            "gender": "male",
            "data": "{\"key\": \"value\"}",
            "created_at": "2025-08-08T02:55:26.000000Z",
            "updated_at": "2025-08-08T02:55:26.000000Z"
        }
    ],
    "total_records": 1
}
```

### **4. GET Request tanpa Data (Table tidak ada)**
```bash
curl -X GET "https://your-domain.com/api/in/ujicoba"
```

**Response:**
```json
{
    "success": true,
    "message": "Data retrieved successfully",
    "received_at": "2025-08-08T02:57:15.314077Z",
    "data": {
        "receiver_name": "Ujicoba Receiver",
        "endpoint": "ujicoba",
        "message": "No data available"
    }
}
```

## 🔧 **Perubahan yang Dilakukan**

### **1. `formatGetResponse()` Method**
```php
protected function formatGetResponse($data, ApiReceiver $receiver)
{
    $response = [
        'success' => true,
        'message' => 'Data retrieved successfully',
        'received_at' => now()->toISOString()
    ];
    
    // Extract relevant data for display
    if (isset($data['data']) && isset($data['data']['records'])) {
        // If there are records from database, show them
        $response['data'] = $data['data']['records'];
        $response['total_records'] = $data['data']['total_records'] ?? 0;
    } elseif (isset($data['data'])) {
        // If there's other data, show it
        $response['data'] = $data['data'];
    } else {
        // Fallback to show receiver info
        $response['data'] = [
            'receiver_name' => $data['receiver_info']['name'] ?? 'Unknown',
            'endpoint' => $data['receiver_info']['endpoint'] ?? 'Unknown',
            'message' => 'No data available'
        ];
    }
    
    return response()->json($response, 200);
}
```

### **2. Data Conversion**
```php
$data['data'] = [
    'total_records' => $total,
    'returned_records' => $records->count(),
    'records' => $records->toArray()  // Convert to array for better JSON response
];
```

## 📊 **Struktur Response GET**

### **Response dengan Data:**
```json
{
    "success": true,
    "message": "Data retrieved successfully",
    "received_at": "2025-08-08T02:57:15.314077Z",
    "data": [
        // Array of records from database
    ],
    "total_records": 5
}
```

### **Response tanpa Data:**
```json
{
    "success": true,
    "message": "Data retrieved successfully",
    "received_at": "2025-08-08T02:57:15.314077Z",
    "data": {
        "receiver_name": "Receiver Name",
        "endpoint": "endpoint_name",
        "message": "No data available"
    }
}
```

## 🚀 **Test Cases**

### **Test 1: GET Normal**
```bash
curl -X GET "https://your-domain.com/api/in/ujicoba"
```
**Expected:** Response dengan data dari database

### **Test 2: GET dengan Pagination**
```bash
curl -X GET "https://your-domain.com/api/in/ujicoba?limit=3&offset=0"
```
**Expected:** Response dengan 3 records pertama

### **Test 3: GET dengan Filter**
```bash
curl -X GET "https://your-domain.com/api/in/ujicoba?nama=test"
```
**Expected:** Response dengan records yang memiliki nama = "test"

## 📋 **Keuntungan Update Ini**

1. **✅ Response Sederhana**: Data langsung ditampilkan tanpa nested structure
2. **✅ Konsistensi**: Format response seragam dengan POST
3. **✅ Pagination**: Mendukung limit, offset, sort, order
4. **✅ Filtering**: Mendukung filter berdasarkan field
5. **✅ Error Handling**: Fallback response jika tidak ada data

## ⚠️ **Catatan Penting**

- **Data JSON**: Field `data` dalam database disimpan sebagai JSON string
- **Pagination**: Default limit 10, maksimal 1000
- **Sorting**: Default sort by `id` desc
- **Filtering**: Semua query parameter (kecuali pagination) akan digunakan sebagai filter

Sekarang GET request akan menampilkan data dengan format yang sederhana dan mudah dibaca! 🎉
