<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class TestController extends Controller
{
    public function test()
    {
        return response()->json([
            'status' => 'success',
            'message' => 'API is working correctly',
            'data' => [
                'timestamp' => now()->toIso8601String(),
                'environment' => app()->environment(),
                'authenticated' => true
            ]
        ]);
    }

    public function user(Request $request)
    {
        // Get the API token from the request
        $token = $request->bearerToken();
        
        return response()->json([
            'status' => 'success',
            'message' => 'Token information retrieved successfully',
            'data' => [
                'token' => substr($token, 0, 10) . '...',  // Only show first 10 chars for security
                'token_type' => 'Bearer',
                'request_info' => [
                    'ip' => $request->ip(),
                    'user_agent' => $request->userAgent(),
                    'method' => $request->method(),
                    'path' => $request->path()
                ]
            ]
        ]);
    }
} 