<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;
use Illuminate\Http\Request;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     */
    protected function redirectTo(Request $request): ?string
    {
        // Allow access to api-tokens and api-clients routes without authentication
        if (str_starts_with($request->path(), 'api-tokens') || 
            str_starts_with($request->path(), 'api-clients')) {
            return null;
        }
        
        return $request->expectsJson() ? null : route('login');
    }
}
