<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class PublicApiAccess
{
    public function handle(Request $request, Closure $next)
    {
        // These paths should be publicly accessible
        $publicPaths = [
            'api-clients',
            'api-tokens',
            'monitoring',
            'analytics'
        ];

        foreach ($publicPaths as $path) {
            if (str_starts_with($request->path(), $path)) {
                return $next($request);
            }
        }

        // For other paths, check if auth is required
        if (auth()->check()) {
            return $next($request);
        }

        // If path requires auth and user is not logged in
        if ($request->expectsJson()) {
            return response()->json(['message' => 'Unauthorized'], 401);
        }

        return redirect()->route('login');
    }
} 