<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\ApiToken;
use Carbon\Carbon;

class ValidateApiToken
{
    public function handle(Request $request, Closure $next)
    {
        $token = $request->bearerToken();

        if (!$token) {
            return response()->json([
                'error' => 'No API token provided',
                'message' => 'Please provide an API token in the Authorization header'
            ], 401);
        }

        $apiToken = ApiToken::where('token', $token)
            ->where('is_revoked', false)
            ->first();

        if (!$apiToken) {
            return response()->json([
                'error' => 'Invalid API token',
                'message' => 'The provided API token is invalid or has been revoked'
            ], 401);
        }

        if ($apiToken->expires_at && $apiToken->expires_at->isPast()) {
            return response()->json([
                'error' => 'Expired API token',
                'message' => 'The provided API token has expired'
            ], 401);
        }

        // Update last used timestamp
        $apiToken->update(['last_used_at' => Carbon::now()]);

        // Add token and client to request for controllers to use
        $request->attributes->add([
            'api_token' => $apiToken,
            'api_client' => $apiToken->client
        ]);

        return $next($request);
    }
} 