<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ApiClient extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'client_id',
        'client_secret',
        'usertoken',
        'passtoken',
        'allowed_endpoints',
        'allowed_ips',
        'is_active',
        'rate_limit',
        'last_used_at',
        'expires_at'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'allowed_endpoints' => 'array',
        'allowed_ips' => 'array',
        'last_used_at' => 'datetime',
        'expires_at' => 'datetime',
        'rate_limit' => 'integer'
    ];

    public function tokens()
    {
        return $this->hasMany(ApiToken::class);
    }
} 