<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ApiLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'api_source_id',
        'endpoint',
        'method',
        'request_headers',
        'request_body',
        'response_headers',
        'response_body',
        'response_data',
        'response_time',
        'status_code',
        'error_message',
        'requested_at'
    ];

    protected $casts = [
        'status_code' => 'integer',
        'response_time' => 'float',
        'requested_at' => 'datetime'
    ];

    public function apiSource()
    {
        return $this->belongsTo(ApiSource::class);
    }
} 