<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ApiReceiveLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'receiver_id',
        'method',
        'ip_address',
        'user_agent',
        'headers',
        'body',
        'query_params',
        'status_code',
        'response_message',
        'response_time',
        'payload_size',
        'auth_success',
        'auth_error',
        'validation_success',
        'validation_errors',
        'saved_to_table',
        'save_error',
        'reference_id'
    ];

    protected $casts = [
        'headers' => 'array',
        'query_params' => 'array',
        'validation_errors' => 'array',
        'auth_success' => 'boolean',
        'validation_success' => 'boolean',
        'saved_to_table' => 'boolean'
    ];

    public function apiReceiver()
    {
        return $this->belongsTo(ApiReceiver::class, 'receiver_id');
    }
} 