<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ApiSendLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'api_target_id',
        'success',
        'status_code',
        'response_time',
        'response_body',
        'error_message',
        'payload',
        'records_sent',
        'retry_count',
        'sent_at',
        'completed_at',
        'batch_id'
    ];

    protected $casts = [
        'success' => 'boolean',
        'status_code' => 'integer',
        'response_time' => 'float',
        'payload' => 'array',
        'response_body' => 'array',
        'records_sent' => 'integer',
        'retry_count' => 'integer',
        'sent_at' => 'datetime',
        'completed_at' => 'datetime'
    ];

    public function apiTarget()
    {
        return $this->belongsTo(ApiTarget::class);
    }
} 