<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class ApiSource extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'url',
        'method',
        'headers',
        'auth_type',
        'auth_token',
        'auth_username',
        'auth_password',
        'table_name',
        'field_mapping',
        'schedule_type',
        'schedule_frequency',
        'status',
        'last_fetched_at',
        'created_by',
        'token'
    ];

    protected $casts = [
        'headers' => 'array',
        'field_mapping' => 'array',
        'last_fetched_at' => 'datetime',
        'schedule_frequency' => 'integer'
    ];

    public function apiLogs()
    {
        return $this->hasMany(ApiLog::class);
    }

    public function getStatsAttribute()
    {
        $logs = $this->apiLogs()->where('created_at', '>=', now()->subDays(30));
        
        return [
            'total_requests' => $logs->count(),
            'success_rate' => $logs->count() > 0 ? ($logs->where('status_code', '>=', 200)->where('status_code', '<', 300)->count() / $logs->count()) * 100 : 100,
            'average_response_time' => $logs->avg('response_time') ?? 0
        ];
    }
} 