<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ApiTarget extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'base_url',
        'endpoint',
        'method',
        'headers',
        'auth_type',
        'auth_token',
        'auth_username',
        'auth_password',
        'source_table',
        'field_mapping',
        'schedule_type',
        'schedule_frequency',
        'is_active',
        'last_sent_at',
        'created_by'
    ];

    protected $casts = [
        'headers' => 'array',
        'field_mapping' => 'array',
        'is_active' => 'boolean',
        'last_sent_at' => 'datetime',
        'schedule_frequency' => 'integer'
    ];

    public function getUrlAttribute()
    {
        return rtrim($this->base_url, '/') . '/' . ltrim($this->endpoint, '/');
    }

    public function sendLogs()
    {
        return $this->hasMany(ApiSendLog::class);
    }
} 