<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ApiTransceiver extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'api_client_id',
        'api_receiver_id',
        'api_target_id',
        'direction',
        'schedule_type',
        'sync_interval',
        'cron_expression',
        'description',
        'is_active',
        'auto_sync',
        'field_mapping',
        'data_filter',
        'auto_forward',
        'schedule_frequency',
        'batch_size'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'auto_sync' => 'boolean',
        'sync_interval' => 'integer',
        'auto_forward' => 'boolean',
        'field_mapping' => 'array',
        'data_filter' => 'array',
        'last_forwarded_at' => 'datetime',
        'total_forwarded' => 'integer',
        'batch_size' => 'integer',
        'delay_seconds' => 'integer',
        'schedule_frequency' => 'integer'
    ];

    public function apiClient()
    {
        return $this->belongsTo(ApiClient::class);
    }

    public function receiver()
    {
        return $this->belongsTo(ApiReceiver::class, 'api_receiver_id');
    }

    public function target()
    {
        return $this->belongsTo(ApiTarget::class, 'api_target_id');
    }

    public function logs()
    {
        return $this->hasMany(ApiTransceiverLog::class);
    }
} 