<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PostOnlyReceiveLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'receiver_id',
        'ip_address',
        'user_agent',
        'headers',
        'body',
        'status_code',
        'response_message',
        'response_time',
        'payload_size',
        'token_valid',
        'validation_success',
        'validation_errors',
        'saved_to_table',
        'save_error',
        'client_id',
        'token_id'
    ];

    protected $casts = [
        'headers' => 'array',
        'validation_errors' => 'array',
        'token_valid' => 'boolean',
        'validation_success' => 'boolean',
        'saved_to_table' => 'boolean',
        'response_time' => 'float',
        'payload_size' => 'integer'
    ];

    /**
     * Relationship dengan PostOnlyReceiver
     */
    public function receiver()
    {
        return $this->belongsTo(PostOnlyReceiver::class, 'receiver_id');
    }

    /**
     * Relationship dengan ApiClient
     */
    public function apiClient()
    {
        return $this->belongsTo(ApiClient::class, 'client_id');
    }

    /**
     * Relationship dengan ApiToken
     */
    public function apiToken()
    {
        return $this->belongsTo(ApiToken::class, 'token_id');
    }
} 