<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transceiver extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'endpoint',
        'method',
        'headers',
        'auth_type',
        'auth_token',
        'auth_username',
        'auth_password',
        'source_table',
        'field_mapping',
        'is_active',
        'created_by',
    ];

    protected $casts = [
        'headers' => 'array',
        'field_mapping' => 'array',
        'is_active' => 'boolean',
    ];
} 