<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Register API Services
        $this->app->singleton(\App\Services\ApiSenderService::class, function ($app) {
            return new \App\Services\ApiSenderService();
        });
        
        $this->app->singleton(\App\Services\ApiTransceiverService::class, function ($app) {
            return new \App\Services\ApiTransceiverService(
                $app->make(\App\Services\ApiSenderService::class)
            );
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
