<?php
// Check if sample-webhook receiver exists in database
header('Content-Type: text/plain');

// Database connection
$host = 'localhost';
$database = 'copg1493_api';
$username = 'copg1493';
$password = 'wPD6DDSegDHd56';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "=== POST-Only Receivers Endpoint Check ===\n\n";
    
    // Check if post_only_receivers table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'post_only_receivers'");
    if ($stmt->rowCount() == 0) {
        echo "❌ Table 'post_only_receivers' does not exist!\n";
        echo "Please run: https://copilotproduction.site/run-sql-script.php\n";
        exit;
    }
    
    echo "✅ Table 'post_only_receivers' exists\n\n";
    
    // Check for sample-webhook endpoint
    $stmt = $pdo->prepare("SELECT * FROM post_only_receivers WHERE endpoint = ?");
    $stmt->execute(['sample-webhook']);
    $receiver = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($receiver) {
        echo "✅ Receiver 'sample-webhook' found:\n";
        echo "   ID: " . $receiver['id'] . "\n";
        echo "   Name: " . $receiver['name'] . "\n";
        echo "   Endpoint: " . $receiver['endpoint'] . "\n";
        echo "   Target Table: " . $receiver['target_table'] . "\n";
        echo "   Active: " . ($receiver['is_active'] ? 'Yes' : 'No') . "\n";
        echo "   Require Token: " . ($receiver['require_token'] ? 'Yes' : 'No') . "\n";
        echo "   API Client ID: " . ($receiver['api_client_id'] ?: 'None') . "\n";
        
        // Check if target table exists
        $targetTable = $receiver['target_table'];
        $stmt = $pdo->query("SHOW TABLES LIKE '$targetTable'");
        if ($stmt->rowCount() > 0) {
            echo "   Target Table Status: ✅ Exists\n";
        } else {
            echo "   Target Table Status: ❌ Does not exist\n";
        }
        
    } else {
        echo "❌ Receiver 'sample-webhook' not found!\n\n";
        
        // Show all available receivers
        $stmt = $pdo->query("SELECT id, name, endpoint, is_active FROM post_only_receivers ORDER BY id");
        $receivers = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        if (count($receivers) > 0) {
            echo "Available receivers:\n";
            foreach ($receivers as $r) {
                $status = $r['is_active'] ? '✅' : '❌';
                echo "   $status ID: {$r['id']}, Name: {$r['name']}, Endpoint: {$r['endpoint']}\n";
            }
        } else {
            echo "No receivers found in database.\n";
            echo "Please create a receiver first at: https://copilotproduction.site/post-only-receivers/create\n";
        }
    }
    
    echo "\n=== API Route Test ===\n";
    echo "Full URL: https://copilotproduction.site/api/post/sample-webhook\n";
    echo "Method: POST\n";
    echo "Headers: Content-Type: application/json\n";
    echo "Body: {\"test\": \"data\"}\n";
    
} catch (PDOException $e) {
    echo "❌ Database connection failed: " . $e->getMessage() . "\n";
    echo "Please check database credentials and connection.\n";
}
?> 