<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

try {
    echo "🔍 Checking API Sources...\n";
    $sources = App\Models\ApiSource::all();
    
    if ($sources->count() > 0) {
        echo "✅ Found " . $sources->count() . " API Source(s):\n";
        foreach ($sources as $source) {
            echo "   - ID: {$source->id}, Name: {$source->name}, URL: {$source->url}\n";
        }
        
        // Test with the first source
        $firstSource = $sources->first();
        echo "\n🧪 Testing ApiLog creation with Source ID: {$firstSource->id}\n";
        
        $apiLog = App\Models\ApiLog::create([
            'api_source_id' => $firstSource->id,
            'endpoint' => $firstSource->url,
            'method' => 'GET',
            'status_code' => 200,
            'response_time' => 150,
            'response_body' => '{"test": "data"}',
            'requested_at' => now()
        ]);
        
        echo "✅ SUCCESS: ApiLog created with ID: {$apiLog->id}\n";
        
    } else {
        echo "❌ No API Sources found. Creating a test source...\n";
        
        $source = App\Models\ApiSource::create([
            'name' => 'Test API Source',
            'url' => 'https://jsonplaceholder.typicode.com/users',
            'method' => 'GET',
            'table_name' => 'test_data',
            'auth_type' => 'none',
            'schedule_type' => 'manual',
            'status' => 'active'
        ]);
        
        echo "✅ Created test API Source with ID: {$source->id}\n";
        
        // Now test ApiLog creation
        $apiLog = App\Models\ApiLog::create([
            'api_source_id' => $source->id,
            'endpoint' => $source->url,
            'method' => 'GET',
            'status_code' => 200,
            'response_time' => 150,
            'response_body' => '{"test": "data"}',
            'requested_at' => now()
        ]);
        
        echo "✅ SUCCESS: ApiLog created with ID: {$apiLog->id}\n";
    }
    
} catch (Exception $e) {
    echo "❌ ERROR: " . $e->getMessage() . "\n";
} 