<?php

// File untuk memeriksa kode autentikasi Basic Auth
// Jalankan file ini untuk debug masalah autentikasi

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;

try {
    echo "=== Debug Basic Auth Code ===\n";
    
    // 1. Cek receiver di database
    $receiver = DB::table('api_receivers')->where('endpoint', 'baden')->first();
    
    if (!$receiver) {
        echo "❌ Receiver 'baden' tidak ditemukan di database\n";
        exit;
    }
    
    echo "✅ Receiver ditemukan:\n";
    echo "ID: {$receiver->id}\n";
    echo "Auth Type: {$receiver->auth_type}\n";
    echo "Username: " . ($receiver->auth_username ?? 'NULL') . "\n";
    echo "Password: " . ($receiver->auth_password ?? 'NULL') . "\n";
    echo "Is Active: " . ($receiver->is_active ? 'Yes' : 'No') . "\n\n";
    
    // 2. Test Basic Auth logic
    echo "=== Test Basic Auth Logic ===\n";
    
    // Simulasi header Authorization
    $testUsername = 'baden';
    $testPassword = 'baden';
    $authHeader = 'Basic ' . base64_encode($testUsername . ':' . $testPassword);
    
    echo "Test Username: '$testUsername'\n";
    echo "Test Password: '$testPassword'\n";
    echo "Auth Header: '$authHeader'\n\n";
    
    // Simulasi proses autentikasi
    if (!$authHeader || !str_starts_with($authHeader, 'Basic ')) {
        echo "❌ Header Authorization tidak valid\n";
    } else {
        echo "✅ Header Authorization valid\n";
        
        // Extract credentials
        $credentials = base64_decode(substr($authHeader, 6));
        $parts = explode(':', $credentials, 2);
        
        echo "Decoded credentials: '$credentials'\n";
        echo "Parts count: " . count($parts) . "\n";
        
        if (count($parts) !== 2) {
            echo "❌ Format credentials tidak valid\n";
        } else {
            $username = $parts[0];
            $password = $parts[1];
            
            echo "Extracted username: '$username'\n";
            echo "Extracted password: '$password'\n";
            echo "Stored username: '" . ($receiver->auth_username ?? 'NULL') . "'\n";
            echo "Stored password: '" . ($receiver->auth_password ?? 'NULL') . "'\n";
            
            // Compare credentials
            $usernameMatch = $username === ($receiver->auth_username ?? '');
            $passwordMatch = $password === ($receiver->auth_password ?? '');
            
            echo "Username match: " . ($usernameMatch ? 'YES' : 'NO') . "\n";
            echo "Password match: " . ($passwordMatch ? 'YES' : 'NO') . "\n";
            
            if ($usernameMatch && $passwordMatch) {
                echo "✅ Basic Auth berhasil!\n";
            } else {
                echo "❌ Basic Auth gagal!\n";
                
                // Debug lebih detail
                echo "\n=== Debug Detail ===\n";
                echo "Username comparison:\n";
                echo "  Provided: '$username' (length: " . strlen($username) . ")\n";
                echo "  Stored: '" . ($receiver->auth_username ?? 'NULL') . "' (length: " . strlen($receiver->auth_username ?? 'NULL') . ")\n";
                echo "  ASCII codes provided: ";
                for ($i = 0; $i < strlen($username); $i++) {
                    echo ord($username[$i]) . " ";
                }
                echo "\n";
                echo "  ASCII codes stored: ";
                for ($i = 0; $i < strlen($receiver->auth_username ?? ''); $i++) {
                    echo ord(($receiver->auth_username ?? '')[$i]) . " ";
                }
                echo "\n";
                
                echo "Password comparison:\n";
                echo "  Provided: '$password' (length: " . strlen($password) . ")\n";
                echo "  Stored: '" . ($receiver->auth_password ?? 'NULL') . "' (length: " . strlen($receiver->auth_password ?? 'NULL') . ")\n";
                echo "  ASCII codes provided: ";
                for ($i = 0; $i < strlen($password); $i++) {
                    echo ord($password[$i]) . " ";
                }
                echo "\n";
                echo "  ASCII codes stored: ";
                for ($i = 0; $i < strlen($receiver->auth_password ?? ''); $i++) {
                    echo ord(($receiver->auth_password ?? '')[$i]) . " ";
                }
                echo "\n";
            }
        }
    }
    
    // 3. Test dengan credentials yang berbeda
    echo "\n=== Test dengan credentials manual ===\n";
    $manualUsername = 'baden';
    $manualPassword = 'baden';
    $manualAuthHeader = 'Basic ' . base64_encode($manualUsername . ':' . $manualPassword);
    
    echo "Manual Auth Header: '$manualAuthHeader'\n";
    
    $manualCredentials = base64_decode(substr($manualAuthHeader, 6));
    $manualParts = explode(':', $manualCredentials, 2);
    
    if (count($manualParts) === 2) {
        $manualExtractedUsername = $manualParts[0];
        $manualExtractedPassword = $manualParts[1];
        
        echo "Manual extracted username: '$manualExtractedUsername'\n";
        echo "Manual extracted password: '$manualExtractedPassword'\n";
        
        $manualUsernameMatch = $manualExtractedUsername === ($receiver->auth_username ?? '');
        $manualPasswordMatch = $manualExtractedPassword === ($receiver->auth_password ?? '');
        
        echo "Manual username match: " . ($manualUsernameMatch ? 'YES' : 'NO') . "\n";
        echo "Manual password match: " . ($manualPasswordMatch ? 'YES' : 'NO') . "\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}
