<?php

// Check Baden receiver in database
echo "=== Check Baden Receiver in Database ===\n";

try {
    // Try different database configurations
    $configs = [
        [
            'host' => '127.0.0.1',
            'dbname' => 'copg1493_api',
            'username' => 'copg1493_api',
            'password' => 'P7H_s;Aco25Vv??J'
        ],
        [
            'host' => 'localhost',
            'dbname' => 'copg1493_api',
            'username' => 'copg1493_api',
            'password' => 'P7H_s;Aco25Vv??J'
        ],
        [
            'host' => '127.0.0.1',
            'dbname' => 'api8',
            'username' => 'root',
            'password' => ''
        ]
    ];
    
    $pdo = null;
    $configUsed = null;
    
    foreach ($configs as $config) {
        echo "Trying database connection: {$config['host']}/{$config['dbname']}\n";
        try {
            $pdo = new PDO(
                "mysql:host={$config['host']};dbname={$config['dbname']};charset=utf8mb4",
                $config['username'],
                $config['password'],
                [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
            );
            $configUsed = $config;
            echo "✅ Database connection successful!\n\n";
            break;
        } catch (Exception $e) {
            echo "❌ Connection failed: " . $e->getMessage() . "\n";
        }
    }
    
    if (!$pdo) {
        echo "❌ All database connections failed\n";
        exit;
    }
    
    // Check if api_receivers table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'api_receivers'");
    if ($stmt->rowCount() == 0) {
        echo "❌ Table 'api_receivers' not found\n";
        exit;
    }
    echo "✅ Table 'api_receivers' exists\n\n";
    
    // Check Baden receiver
    $stmt = $pdo->prepare("SELECT * FROM api_receivers WHERE endpoint = ?");
    $stmt->execute(['baden']);
    $receiver = $stmt->fetch(PDO::FETCH_OBJ);
    
    if (!$receiver) {
        echo "❌ Receiver 'baden' not found in database\n";
        echo "Creating Baden receiver...\n";
        
        $insertStmt = $pdo->prepare("
            INSERT INTO api_receivers (
                name, description, endpoint, target_table, 
                auth_type, auth_username, auth_password,
                allowed_methods, is_active, created_at, updated_at
            ) VALUES (
                ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW()
            )
        ");
        
        $insertStmt->execute([
            'Baden Basic Auth Receiver',
            'Receiver for Baden System with Basic Authentication',
            'baden',
            'orders',
            'basic_auth',
            'baden',
            'baden',
            'GET,POST,PUT,DELETE',
            1
        ]);
        
        echo "✅ Baden receiver created successfully\n";
        
        // Fetch the newly created receiver
        $stmt = $pdo->prepare("SELECT * FROM api_receivers WHERE endpoint = ?");
        $stmt->execute(['baden']);
        $receiver = $stmt->fetch(PDO::FETCH_OBJ);
    }
    
    echo "✅ Baden receiver found:\n";
    echo "ID: {$receiver->id}\n";
    echo "Name: {$receiver->name}\n";
    echo "Endpoint: {$receiver->endpoint}\n";
    echo "Auth Type: {$receiver->auth_type}\n";
    echo "Username: " . ($receiver->auth_username ?? 'NULL') . "\n";
    echo "Password: " . ($receiver->auth_password ?? 'NULL') . "\n";
    echo "Is Active: " . ($receiver->is_active ? 'Yes' : 'No') . "\n\n";
    
    // Test Basic Auth logic
    echo "=== Test Basic Auth Logic ===\n";
    $testUsername = 'baden';
    $testPassword = 'baden';
    $authHeader = 'Basic ' . base64_encode($testUsername . ':' . $testPassword);
    
    echo "Test Username: '$testUsername'\n";
    echo "Test Password: '$testPassword'\n";
    echo "Auth Header: '$authHeader'\n\n";
    
    // Simulate authentication process
    if (str_starts_with($authHeader, 'Basic ')) {
        $credentials = base64_decode(substr($authHeader, 6));
        $parts = explode(':', $credentials, 2);
        
        if (count($parts) === 2) {
            $username = $parts[0];
            $password = $parts[1];
            
            echo "Extracted username: '$username'\n";
            echo "Extracted password: '$password'\n";
            echo "Stored username: '" . ($receiver->auth_username ?? 'NULL') . "'\n";
            echo "Stored password: '" . ($receiver->auth_password ?? 'NULL') . "'\n";
            
            $usernameMatch = $username === ($receiver->auth_username ?? '');
            $passwordMatch = $password === ($receiver->auth_password ?? '');
            
            echo "Username match: " . ($usernameMatch ? 'YES' : 'NO') . "\n";
            echo "Password match: " . ($passwordMatch ? 'YES' : 'NO') . "\n";
            
            if ($usernameMatch && $passwordMatch) {
                echo "✅ Basic Auth should work!\n";
            } else {
                echo "❌ Basic Auth will fail!\n";
                
                // Debug more details
                echo "\n=== Debug Details ===\n";
                echo "Username comparison:\n";
                echo "  Provided: '$username' (length: " . strlen($username) . ")\n";
                echo "  Stored: '" . ($receiver->auth_username ?? 'NULL') . "' (length: " . strlen($receiver->auth_username ?? 'NULL') . ")\n";
                echo "  ASCII codes provided: ";
                for ($i = 0; $i < strlen($username); $i++) {
                    echo ord($username[$i]) . " ";
                }
                echo "\n";
                echo "  ASCII codes stored: ";
                for ($i = 0; $i < strlen($receiver->auth_username ?? ''); $i++) {
                    echo ord(($receiver->auth_username ?? '')[$i]) . " ";
                }
                echo "\n";
            }
        }
    }
    
    // Check if there are other receivers that might be interfering
    echo "\n=== Check Other Receivers ===\n";
    $stmt = $pdo->query("SELECT id, name, endpoint, auth_type, auth_username, auth_password, is_active FROM api_receivers ORDER BY id");
    $receivers = $stmt->fetchAll(PDO::FETCH_OBJ);
    
    echo "Total receivers: " . count($receivers) . "\n";
    foreach ($receivers as $rec) {
        echo "ID: {$rec->id}, Name: {$rec->name}, Endpoint: {$rec->endpoint}, Auth: {$rec->auth_type}, Active: " . ($rec->is_active ? 'Yes' : 'No') . "\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}
