<?php
/**
 * Script untuk mengecek konfigurasi Bearer Token Receivers
 */

require_once 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\ApiReceiver;
use App\Models\ApiClient;
use App\Models\ApiToken;

echo "=== BEARER TOKEN RECEIVER CONFIGURATION ===\n\n";

// Find receivers with bearer_token auth_type
$receivers = ApiReceiver::where('auth_type', 'bearer_token')->get();

if ($receivers->isEmpty()) {
    echo "No receivers found with auth_type='bearer_token'\n";
} else {
    foreach ($receivers as $receiver) {
        echo "Receiver ID: {$receiver->id}\n";
        echo "Name: {$receiver->name}\n";
        echo "Endpoint: {$receiver->endpoint}\n";
        echo "Auth Type: {$receiver->auth_type}\n";
        echo "Auth Token: " . ($receiver->auth_token ? $receiver->auth_token : 'NULL') . "\n";
        echo "API Client ID: " . ($receiver->api_client_id ? $receiver->api_client_id : 'NULL') . "\n";
        echo "Is Active: " . ($receiver->is_active ? 'Yes' : 'No') . "\n";
        
        // Check API Client if linked
        if ($receiver->api_client_id) {
            $client = ApiClient::find($receiver->api_client_id);
            if ($client) {
                echo "API Client: {$client->name} (Active: " . ($client->is_active ? 'Yes' : 'No') . ")\n";
                
                // Check tokens for this client
                $tokens = ApiToken::where('api_client_id', $client->id)
                    ->where('is_revoked', false)
                    ->get();
                echo "Valid Tokens: " . $tokens->count() . "\n";
                foreach ($tokens as $token) {
                    echo "  - Token: {$token->token} (Expires: " . ($token->expires_at ? $token->expires_at : 'Never') . ")\n";
                }
            } else {
                echo "API Client: NOT FOUND\n";
            }
        }
        echo "---\n";
    }
}

echo "\n=== ALL RECEIVERS (for reference) ===\n";
$allReceivers = ApiReceiver::all();
foreach ($allReceivers as $receiver) {
    echo "ID: {$receiver->id}, Endpoint: {$receiver->endpoint}, Auth Type: {$receiver->auth_type}, Active: " . ($receiver->is_active ? 'Yes' : 'No') . "\n";
}
