<?php

// File untuk memeriksa kode controller
// Jalankan file ini untuk debug masalah autentikasi

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;

try {
    echo "=== CHECK CONTROLLER CODE ===\n";
    
    // 1. Cek receiver di database
    $receiver = DB::table('api_receivers')->where('endpoint', 'baden')->first();
    
    if (!$receiver) {
        echo "❌ Receiver 'baden' tidak ditemukan di database\n";
        exit;
    }
    
    echo "✅ Receiver ditemukan:\n";
    echo "ID: {$receiver->id}\n";
    echo "Auth Type: {$receiver->auth_type}\n";
    echo "Username: " . ($receiver->auth_username ?? 'NULL') . "\n";
    echo "Password: " . ($receiver->auth_password ?? 'NULL') . "\n";
    echo "Is Active: " . ($receiver->is_active ? 'Yes' : 'No') . "\n\n";
    
    // 2. Test dengan berbagai skenario
    echo "=== TEST BERBAGAI SKENARIO ===\n";
    
    $testCases = [
        [
            'name' => 'Test 1: Credentials yang benar',
            'username' => 'baden',
            'password' => 'baden',
            'expected' => true
        ],
        [
            'name' => 'Test 2: Username salah',
            'username' => 'wrong',
            'password' => 'baden',
            'expected' => false
        ],
        [
            'name' => 'Test 3: Password salah',
            'username' => 'baden',
            'password' => 'wrong',
            'expected' => false
        ],
        [
            'name' => 'Test 4: Keduanya salah',
            'username' => 'wrong',
            'password' => 'wrong',
            'expected' => false
        ],
        [
            'name' => 'Test 5: Username kosong',
            'username' => '',
            'password' => 'baden',
            'expected' => false
        ],
        [
            'name' => 'Test 6: Password kosong',
            'username' => 'baden',
            'password' => '',
            'expected' => false
        ]
    ];
    
    foreach ($testCases as $test) {
        echo "\n--- {$test['name']} ---\n";
        
        $authHeader = 'Basic ' . base64_encode($test['username'] . ':' . $test['password']);
        echo "Auth Header: '$authHeader'\n";
        
        // Simulasi proses autentikasi seperti di controller
        if (!$authHeader || !str_starts_with($authHeader, 'Basic ')) {
            echo "❌ Header Authorization tidak valid\n";
            continue;
        }
        
        $credentials = base64_decode(substr($authHeader, 6));
        $parts = explode(':', $credentials, 2);
        
        if (count($parts) !== 2) {
            echo "❌ Format credentials tidak valid\n";
            continue;
        }
        
        $username = $parts[0];
        $password = $parts[1];
        
        echo "Extracted Username: '$username'\n";
        echo "Extracted Password: '$password'\n";
        echo "Stored Username: '" . ($receiver->auth_username ?? 'NULL') . "'\n";
        echo "Stored Password: '" . ($receiver->auth_password ?? 'NULL') . "'\n";
        
        $usernameMatch = $username === ($receiver->auth_username ?? '');
        $passwordMatch = $password === ($receiver->auth_password ?? '');
        
        echo "Username Match: " . ($usernameMatch ? 'YES' : 'NO') . "\n";
        echo "Password Match: " . ($passwordMatch ? 'YES' : 'NO') . "\n";
        
        $result = $usernameMatch && $passwordMatch;
        echo "Result: " . ($result ? 'SUCCESS' : 'FAILED') . "\n";
        echo "Expected: " . ($test['expected'] ? 'SUCCESS' : 'FAILED') . "\n";
        echo "Test: " . ($result === $test['expected'] ? 'PASS' : 'FAIL') . "\n";
    }
    
    // 3. Test dengan karakter khusus
    echo "\n=== TEST KARAKTER KHUSUS ===\n";
    
    $specialTests = [
        'baden:baden',
        'baden: baden',
        'baden :baden',
        'baden : baden',
        'baden',
        ':baden',
        'baden:',
        ':'
    ];
    
    foreach ($specialTests as $test) {
        echo "\n--- Test: '$test' ---\n";
        
        $authHeader = 'Basic ' . base64_encode($test);
        echo "Auth Header: '$authHeader'\n";
        
        $credentials = base64_decode(substr($authHeader, 6));
        echo "Decoded: '$credentials'\n";
        
        $parts = explode(':', $credentials, 2);
        echo "Parts: " . implode(', ', array_map(function($part) { return "'$part'"; }, $parts)) . "\n";
        
        if (count($parts) === 2) {
            $username = $parts[0];
            $password = $parts[1];
            
            $usernameMatch = $username === ($receiver->auth_username ?? '');
            $passwordMatch = $password === ($receiver->auth_password ?? '');
            
            echo "Username Match: " . ($usernameMatch ? 'YES' : 'NO') . "\n";
            echo "Password Match: " . ($passwordMatch ? 'YES' : 'NO') . "\n";
            echo "Result: " . (($usernameMatch && $passwordMatch) ? 'SUCCESS' : 'FAILED') . "\n";
        } else {
            echo "❌ Invalid format\n";
        }
    }
    
    // 4. Debug detail untuk credentials yang benar
    echo "\n=== DEBUG DETAIL UNTUK CREDENTIALS BENAR ===\n";
    
    $correctUsername = 'baden';
    $correctPassword = 'baden';
    $authHeader = 'Basic ' . base64_encode($correctUsername . ':' . $correctPassword);
    
    echo "Correct Username: '$correctUsername'\n";
    echo "Correct Password: '$correctPassword'\n";
    echo "Auth Header: '$authHeader'\n";
    
    $credentials = base64_decode(substr($authHeader, 6));
    echo "Decoded Credentials: '$credentials'\n";
    
    $parts = explode(':', $credentials, 2);
    if (count($parts) === 2) {
        $username = $parts[0];
        $password = $parts[1];
        
        echo "Extracted Username: '$username' (length: " . strlen($username) . ")\n";
        echo "Extracted Password: '$password' (length: " . strlen($password) . ")\n";
        echo "Stored Username: '" . ($receiver->auth_username ?? 'NULL') . "' (length: " . strlen($receiver->auth_username ?? 'NULL') . ")\n";
        echo "Stored Password: '" . ($receiver->auth_password ?? 'NULL') . "' (length: " . strlen($receiver->auth_password ?? 'NULL') . ")\n";
        
        // ASCII comparison
        echo "Username ASCII (extracted): ";
        for ($i = 0; $i < strlen($username); $i++) {
            echo ord($username[$i]) . " ";
        }
        echo "\n";
        
        echo "Username ASCII (stored): ";
        for ($i = 0; $i < strlen($receiver->auth_username ?? ''); $i++) {
            echo ord(($receiver->auth_username ?? '')[$i]) . " ";
        }
        echo "\n";
        
        echo "Password ASCII (extracted): ";
        for ($i = 0; $i < strlen($password); $i++) {
            echo ord($password[$i]) . " ";
        }
        echo "\n";
        
        echo "Password ASCII (stored): ";
        for ($i = 0; $i < strlen($receiver->auth_password ?? ''); $i++) {
            echo ord(($receiver->auth_password ?? '')[$i]) . " ";
        }
        echo "\n";
        
        $usernameMatch = $username === ($receiver->auth_username ?? '');
        $passwordMatch = $password === ($receiver->auth_password ?? '');
        
        echo "Username Match: " . ($usernameMatch ? 'YES' : 'NO') . "\n";
        echo "Password Match: " . ($passwordMatch ? 'YES' : 'NO') . "\n";
        echo "Final Result: " . (($usernameMatch && $passwordMatch) ? 'SUCCESS' : 'FAILED') . "\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}
