<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\ApiReceiver;

echo "API Receivers:\n";
$receivers = ApiReceiver::all();

foreach ($receivers as $receiver) {
    echo "ID: {$receiver->id}\n";
    echo "Name: {$receiver->name}\n";
    echo "Endpoint: {$receiver->endpoint}\n";
    echo "Auth Type: {$receiver->auth_type}\n";
    echo "Auth Username: {$receiver->auth_username}\n";
    echo "Auth Password: {$receiver->auth_password}\n";
    echo "Is Active: " . ($receiver->is_active ? 'Yes' : 'No') . "\n";
    echo "---\n";
}
