<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;

echo "=== API TARGETS TABLE STRUCTURE ===\n\n";

try {
    $columns = DB::select('SHOW COLUMNS FROM api_targets');
    
    echo "Columns in api_targets table:\n";
    foreach ($columns as $col) {
        echo "- {$col->Field} ({$col->Type})";
        if ($col->Null === 'NO') {
            echo " NOT NULL";
        }
        if ($col->Default !== null) {
            echo " DEFAULT '{$col->Default}'";
        }
        echo "\n";
    }
    
    echo "\n=== CHECKING FOR SCHEDULE COLUMNS ===\n";
    $hasScheduleType = false;
    $hasScheduleFrequency = false;
    
    foreach ($columns as $col) {
        if ($col->Field === 'schedule_type') {
            $hasScheduleType = true;
            echo "✓ schedule_type column exists\n";
        }
        if ($col->Field === 'schedule_frequency') {
            $hasScheduleFrequency = true;
            echo "✓ schedule_frequency column exists\n";
        }
    }
    
    if (!$hasScheduleType) {
        echo "❌ schedule_type column missing\n";
    }
    if (!$hasScheduleFrequency) {
        echo "❌ schedule_frequency column missing\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
} 