<?php
/**
 * MANUAL CACHE CLEARING SCRIPT
 * Clear Laravel cache manually and force route reloading
 */

echo "<h1>🧹 Manual Cache Clearing</h1>";

$basePath = __DIR__;
$success = [];
$errors = [];

// 1. Delete cache files manually
$cacheFiles = [
    'bootstrap/cache/config.php',
    'bootstrap/cache/routes.php', 
    'bootstrap/cache/services.php',
    'bootstrap/cache/packages.php'
];

echo "<h2>Step 1: Delete Cache Files</h2>";
foreach ($cacheFiles as $file) {
    $fullPath = $basePath . '/' . $file;
    if (file_exists($fullPath)) {
        if (unlink($fullPath)) {
            $success[] = "✅ Deleted: $file";
        } else {
            $errors[] = "❌ Failed to delete: $file";
        }
    } else {
        $success[] = "ℹ️ Not found (OK): $file";
    }
}

// 2. Clear storage cache directories
$cacheDirectories = [
    'storage/framework/cache/data',
    'storage/framework/views',
    'storage/framework/sessions'
];

echo "<h2>Step 2: Clear Cache Directories</h2>";
foreach ($cacheDirectories as $dir) {
    $fullPath = $basePath . '/' . $dir;
    if (is_dir($fullPath)) {
        $files = glob($fullPath . '/*');
        $cleared = 0;
        foreach ($files as $file) {
            if (is_file($file)) {
                if (unlink($file)) {
                    $cleared++;
                }
            }
        }
        $success[] = "✅ Cleared $cleared files from: $dir";
    } else {
        $success[] = "ℹ️ Directory not found: $dir";
    }
}

// 3. Try Laravel Artisan commands
echo "<h2>Step 3: Run Artisan Commands</h2>";
if (file_exists($basePath . '/artisan')) {
    $commands = ['route:clear', 'config:clear', 'cache:clear', 'view:clear'];
    foreach ($commands as $cmd) {
        try {
            $output = shell_exec("cd $basePath && php artisan $cmd 2>&1");
            if ($output !== null) {
                $success[] = "✅ php artisan $cmd: " . trim($output);
            } else {
                $errors[] = "❌ php artisan $cmd failed";
            }
        } catch (Exception $e) {
            $errors[] = "❌ php artisan $cmd error: " . $e->getMessage();
        }
    }
} else {
    $errors[] = "❌ Artisan file not found";
}

// 4. Show results
echo "<h2>Results</h2>";

if (count($success) > 0) {
    echo "<div style='background: #d4edda; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
    echo "<h3 style='color: #155724;'>✅ Successful Operations:</h3>";
    foreach ($success as $msg) {
        echo "<p style='margin: 5px 0; color: #155724;'>$msg</p>";
    }
    echo "</div>";
}

if (count($errors) > 0) {
    echo "<div style='background: #f8d7da; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
    echo "<h3 style='color: #721c24;'>❌ Errors:</h3>";
    foreach ($errors as $msg) {
        echo "<p style='margin: 5px 0; color: #721c24;'>$msg</p>";
    }
    echo "</div>";
}

echo "<h2>Next Steps</h2>";
echo "<div style='background: #cce5ff; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
echo "<p><strong>1. Test Import Function:</strong></p>";
echo "<p><a href='/api-sources' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Go to API Sources</a></p>";
echo "<p><strong>2. Clear Browser Cache:</strong></p>";
echo "<p>Press Ctrl+F5 or Ctrl+Shift+R to refresh your browser cache</p>";
echo "<p><strong>3. Run This Script Again:</strong></p>";
echo "<p><a href='/clear-cache-manual.php' style='background: #28a745; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Clear Cache Again</a></p>";
echo "</div>";
?> 