<?php
// Clear Laravel cache script
// This script will clear route cache, config cache, and view cache

echo "Starting Laravel cache clearing...\n";

// Clear route cache
if (file_exists(__DIR__ . '/bootstrap/cache/routes.php')) {
    unlink(__DIR__ . '/bootstrap/cache/routes.php');
    echo "✓ Route cache cleared\n";
} else {
    echo "✓ Route cache already clear\n";
}

// Clear config cache
if (file_exists(__DIR__ . '/bootstrap/cache/config.php')) {
    unlink(__DIR__ . '/bootstrap/cache/config.php');
    echo "✓ Config cache cleared\n";
} else {
    echo "✓ Config cache already clear\n";
}

// Clear view cache
$viewCacheDir = __DIR__ . '/storage/framework/views';
if (is_dir($viewCacheDir)) {
    $files = glob($viewCacheDir . '/*');
    foreach ($files as $file) {
        if (is_file($file)) {
            unlink($file);
        }
    }
    echo "✓ View cache cleared\n";
} else {
    echo "✓ View cache directory not found\n";
}

// Clear application cache
$cacheDir = __DIR__ . '/storage/framework/cache/data';
if (is_dir($cacheDir)) {
    function deleteDirectory($dir) {
        if (!is_dir($dir)) {
            return;
        }
        $files = array_diff(scandir($dir), array('.', '..'));
        foreach ($files as $file) {
            $path = $dir . '/' . $file;
            if (is_dir($path)) {
                deleteDirectory($path);
            } else {
                unlink($path);
            }
        }
        return rmdir($dir);
    }
    
    $files = glob($cacheDir . '/*');
    foreach ($files as $file) {
        if (is_file($file)) {
            unlink($file);
        } elseif (is_dir($file)) {
            deleteDirectory($file);
        }
    }
    echo "✓ Application cache cleared\n";
} else {
    echo "✓ Application cache directory not found\n";
}

// Clear session files
$sessionDir = __DIR__ . '/storage/framework/sessions';
if (is_dir($sessionDir)) {
    $files = glob($sessionDir . '/*');
    foreach ($files as $file) {
        if (is_file($file)) {
            unlink($file);
        }
    }
    echo "✓ Session files cleared\n";
} else {
    echo "✓ Session directory not found\n";
}

echo "\nCache clearing completed!\n";
echo "Please try accessing the import route again.\n";
?> 