<?php

// Patch for GetOnlyReceiverController.php store method
// Add this code before the validator in the store method

public function store(Request $request)
{
    // PRE-PROCESS REQUEST DATA
    
    // 1. Handle array fields from comma-separated strings
    if ($request->has("response_fields") && is_string($request->response_fields)) {
        $fields = array_filter(array_map("trim", explode(",", $request->response_fields)));
        $request->merge(["response_fields" => $fields]);
    }

    if ($request->has("cors_origins") && is_string($request->cors_origins)) {
        $origins = array_filter(array_map("trim", explode(",", $request->cors_origins)));
        $request->merge(["cors_origins" => $origins]);
    }

    // 2. Handle boolean fields properly (checkboxes that are unchecked dont send values)
    $booleanFields = ["enable_pagination", "require_token", "enable_cors", "enable_cache", "is_active"];
    foreach ($booleanFields as $field) {
        if (!$request->has($field)) {
            $request->merge([$field => false]);
        } else {
            $request->merge([$field => true]);
        }
    }

    // 3. Set default values for optional fields
    if (!$request->has("description")) {
        $request->merge(["description" => null]);
    }

    // 4. Generate endpoint from name if empty
    if (!$request->has("endpoint") || empty($request->endpoint)) {
        $endpoint = Str::slug($request->name) . "-" . Str::random(6);
        $request->merge(["endpoint" => $endpoint]);
    }

    // CONTINUE WITH EXISTING VALIDATION...
    $validator = Validator::make($request->all(), [
        // ... existing validation rules
    ]);
    
    // REST OF THE METHOD REMAINS THE SAME
}
