<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

try {
    echo "Creating test data for API Source 4...\n";
    
    // Find API source with ID 4
    $apiSource = App\Models\ApiSource::find(4);
    
    if (!$apiSource) {
        echo "ERROR: API Source with ID 4 not found.\n";
        exit(1);
    }
    
    echo "Found API Source: {$apiSource->name}\n";
    
    // Clear existing logs
    $apiSource->apiLogs()->delete();
    echo "Cleared existing logs\n";
    
    // Create test data
    $sampleData = [
        [
            'id' => 1,
            'name' => 'Ahmad Dhani',
            'email' => 'ahmad@example.com',
            'phone' => '+62812345678',
            'address' => 'Jakarta, Indonesia',
            'status' => 'active',
            'created_at' => '2025-01-15 10:30:00',
            'updated_at' => '2025-01-15 10:30:00'
        ],
        [
            'id' => 2,
            'name' => 'Siti Nurhaliza',
            'email' => 'siti@example.com',
            'phone' => '+62812345679',
            'address' => 'Bandung, Indonesia',
            'status' => 'active',
            'created_at' => '2025-01-15 11:45:00',
            'updated_at' => '2025-01-15 11:45:00'
        ],
        [
            'id' => 3,
            'name' => 'Budi Santoso',
            'email' => 'budi@example.com',
            'phone' => '+62812345680',
            'address' => 'Surabaya, Indonesia',
            'status' => 'inactive',
            'created_at' => '2025-01-15 14:20:00',
            'updated_at' => '2025-01-15 14:20:00'
        ],
        [
            'id' => 4,
            'name' => 'Dewi Sartika',
            'email' => 'dewi@example.com',
            'phone' => '+62812345681',
            'address' => 'Yogyakarta, Indonesia',
            'status' => 'active',
            'created_at' => '2025-01-15 16:10:00',
            'updated_at' => '2025-01-15 16:10:00'
        ],
        [
            'id' => 5,
            'name' => 'Rudi Hartono',
            'email' => 'rudi@example.com',
            'phone' => '+62812345682',
            'address' => 'Medan, Indonesia',
            'status' => 'pending',
            'created_at' => '2025-01-15 18:30:00',
            'updated_at' => '2025-01-15 18:30:00'
        ]
    ];
    
    // Create import logs
    for ($i = 1; $i <= 2; $i++) {
        $importDate = now()->subDays($i);
        $recordsCount = count($sampleData);
        
        $log = App\Models\ApiLog::create([
            'api_source_id' => $apiSource->id,
            'endpoint' => $apiSource->url,
            'method' => 'GET',
            'status_code' => 200,
            'response_code' => 200,
            'status' => 'success',
            'response_time' => rand(100, 500),
            'response_body' => json_encode($sampleData),
            'records_imported' => $recordsCount,
            'requested_at' => $importDate,
            'created_at' => $importDate,
            'updated_at' => $importDate
        ]);
        
        echo "Created import log #{$i} with {$recordsCount} records\n";
    }
    
    // Update last_fetched_at
    $apiSource->update(['last_fetched_at' => now()]);
    
    echo "SUCCESS: Test data created!\n";
    echo "Visit: https://copilotproduction.site/api-sources/4/data\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    exit(1);
} 