<?php

/**
 * Script untuk membuat table get_only_receivers dan menambahkan data sample
 */

// Database configuration
$host = 'localhost';
$dbname = 'copg1493_api';
$username = 'copg1493_api';
$password = 'apipassword123';

try {
    // Create PDO connection
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "=== CREATE GET-ONLY RECEIVERS TABLE & DATA ===\n";
    echo "✅ Database connection successful\n\n";
    
    // 1. Create table
    echo "📋 Creating table get_only_receivers...\n";
    $createTableSQL = "
    CREATE TABLE IF NOT EXISTS get_only_receivers (
        id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
        name varchar(255) NOT NULL COMMENT 'Descriptive name for the receiver',
        description text DEFAULT NULL COMMENT 'Optional description',
        endpoint varchar(255) NOT NULL COMMENT 'URL endpoint (alphanumeric, dash, underscore only)',
        data_source enum('table','api','custom') NOT NULL COMMENT 'Source of data: database table, external API, or custom query',
        source_table varchar(255) DEFAULT NULL COMMENT 'Database table name (if data_source is table)',
        source_api_url varchar(500) DEFAULT NULL COMMENT 'External API URL (if data_source is api)',
        source_api_headers json DEFAULT NULL COMMENT 'Headers for external API requests',
        custom_query text DEFAULT NULL COMMENT 'Custom SQL query (if data_source is custom)',
        api_token_id bigint(20) unsigned DEFAULT NULL COMMENT 'Associated API token for authentication',
        require_token tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Whether authentication is required',
        allowed_tokens json DEFAULT NULL COMMENT 'List of allowed token IDs',
        response_format enum('json','xml','csv') NOT NULL DEFAULT 'json' COMMENT 'Response format',
        response_fields json DEFAULT NULL COMMENT 'Fields to include in response',
        default_filters json DEFAULT NULL COMMENT 'Default filters to apply',
        allowed_filters json DEFAULT NULL COMMENT 'Allowed filter parameters',
        default_limit int(11) NOT NULL DEFAULT 50 COMMENT 'Default number of records to return',
        max_limit int(11) NOT NULL DEFAULT 1000 COMMENT 'Maximum allowed limit',
        enable_pagination tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Whether to enable pagination',
        rate_limit_per_minute int(11) NOT NULL DEFAULT 60 COMMENT 'Rate limit per minute',
        rate_limit_per_hour int(11) NOT NULL DEFAULT 1000 COMMENT 'Rate limit per hour',
        allowed_ips json DEFAULT NULL COMMENT 'IP whitelist',
        enable_cors tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Enable CORS headers',
        cors_origins json DEFAULT NULL COMMENT 'Allowed CORS origins',
        enable_cache tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Enable response caching',
        cache_duration int(11) NOT NULL DEFAULT 300 COMMENT 'Cache duration in seconds',
        cache_key_prefix varchar(100) DEFAULT NULL COMMENT 'Cache key prefix',
        validation_rules json DEFAULT NULL COMMENT 'Validation rules for parameters',
        required_parameters json DEFAULT NULL COMMENT 'Required query parameters',
        optional_parameters json DEFAULT NULL COMMENT 'Optional query parameters',
        is_active tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Whether the receiver is active',
        total_requests int(11) NOT NULL DEFAULT 0 COMMENT 'Total number of requests received',
        total_success int(11) NOT NULL DEFAULT 0 COMMENT 'Total successful responses',
        total_errors int(11) NOT NULL DEFAULT 0 COMMENT 'Total error responses',
        last_accessed_at timestamp NULL DEFAULT NULL COMMENT 'Last time the receiver was accessed',
        avg_response_time decimal(8,3) DEFAULT NULL COMMENT 'Average response time in seconds',
        metadata json DEFAULT NULL COMMENT 'Additional metadata',
        created_by bigint(20) unsigned DEFAULT NULL COMMENT 'User who created this receiver',
        created_at timestamp NULL DEFAULT NULL,
        updated_at timestamp NULL DEFAULT NULL,
        PRIMARY KEY (id),
        UNIQUE KEY get_only_receivers_endpoint_unique (endpoint),
        KEY get_only_receivers_api_token_id_foreign (api_token_id),
        KEY get_only_receivers_created_by_foreign (created_by),
        KEY get_only_receivers_data_source_index (data_source),
        KEY get_only_receivers_is_active_index (is_active),
        KEY get_only_receivers_response_format_index (response_format)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='GET-only API receivers for providing data endpoints';
    ";
    
    $pdo->exec($createTableSQL);
    echo "✅ Table created successfully\n\n";
    
    // 2. Add migration record
    echo "📋 Adding migration record...\n";
    $migrationSQL = "
    INSERT IGNORE INTO migrations (migration, batch) 
    VALUES ('2025_07_05_104252_create_get_only_receivers_table', 1)
    ";
    $pdo->exec($migrationSQL);
    echo "✅ Migration record added\n\n";
    
    // 3. Clear existing data
    echo "📋 Clearing existing data...\n";
    $pdo->exec("DELETE FROM get_only_receivers");
    echo "✅ Data cleared\n\n";
    
    // 4. Insert sample data
    echo "📋 Inserting sample data...\n";
    
    $sampleData = [
        [
            'name' => 'User Data API',
            'description' => 'Endpoint untuk mengambil data user dengan pagination dan filtering',
            'endpoint' => 'users',
            'data_source' => 'table',
            'source_table' => 'users',
            'response_format' => 'json',
            'response_fields' => '["id", "name", "email", "created_at"]',
            'default_filters' => '{"status": "active"}',
            'allowed_filters' => '["status", "role", "created_at"]',
            'default_limit' => 20,
            'max_limit' => 500,
            'enable_pagination' => 1,
            'rate_limit_per_minute' => 100,
            'rate_limit_per_hour' => 2000,
            'enable_cors' => 1,
            'cors_origins' => '["https://app.example.com", "https://admin.example.com"]',
            'enable_cache' => 1,
            'cache_duration' => 600,
            'cache_key_prefix' => 'users_api',
            'require_token' => 1,
            'is_active' => 1,
            'total_requests' => 1250,
            'total_success' => 1198,
            'total_errors' => 52,
            'avg_response_time' => 0.145,
            'created_by' => 1,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        ],
        [
            'name' => 'Product Catalog API',
            'description' => 'API untuk menampilkan katalog produk dengan fitur pencarian dan filter kategori',
            'endpoint' => 'products',
            'data_source' => 'custom',
            'custom_query' => 'SELECT p.id, p.name, p.price, p.stock, c.name as category FROM products p LEFT JOIN categories c ON p.category_id = c.id WHERE p.is_active = 1',
            'response_format' => 'json',
            'response_fields' => '["id", "name", "price", "stock", "category"]',
            'default_filters' => '{"is_active": 1}',
            'allowed_filters' => '["category", "price_min", "price_max", "in_stock"]',
            'default_limit' => 50,
            'max_limit' => 1000,
            'enable_pagination' => 1,
            'rate_limit_per_minute' => 200,
            'rate_limit_per_hour' => 5000,
            'enable_cors' => 1,
            'cors_origins' => '["*"]',
            'enable_cache' => 1,
            'cache_duration' => 900,
            'cache_key_prefix' => 'products_api',
            'require_token' => 0,
            'is_active' => 1,
            'total_requests' => 3456,
            'total_success' => 3401,
            'total_errors' => 55,
            'avg_response_time' => 0.089,
            'created_by' => 1,
            'created_at' => date('Y-m-d H:i:s', strtotime('-2 days')),
            'updated_at' => date('Y-m-d H:i:s', strtotime('-1 day'))
        ],
        [
            'name' => 'External Weather API',
            'description' => 'Proxy untuk mengambil data cuaca dari API eksternal dengan caching',
            'endpoint' => 'weather',
            'data_source' => 'api',
            'source_api_url' => 'https://api.openweathermap.org/data/2.5/weather',
            'source_api_headers' => '{"Authorization": "Bearer YOUR_API_KEY", "Content-Type": "application/json"}',
            'response_format' => 'json',
            'response_fields' => '["weather", "main", "wind", "name"]',
            'default_filters' => '{}',
            'allowed_filters' => '["q", "lat", "lon", "units"]',
            'default_limit' => 1,
            'max_limit' => 1,
            'enable_pagination' => 0,
            'rate_limit_per_minute' => 30,
            'rate_limit_per_hour' => 500,
            'enable_cors' => 1,
            'cors_origins' => '["https://weather.example.com"]',
            'enable_cache' => 1,
            'cache_duration' => 1800,
            'cache_key_prefix' => 'weather_api',
            'require_token' => 1,
            'is_active' => 1,
            'total_requests' => 892,
            'total_success' => 876,
            'total_errors' => 16,
            'avg_response_time' => 0.234,
            'created_by' => 1,
            'created_at' => date('Y-m-d H:i:s', strtotime('-5 days')),
            'updated_at' => date('Y-m-d H:i:s', strtotime('-3 hours'))
        ],
        [
            'name' => 'Analytics Data Export',
            'description' => 'Export data analytics dalam format CSV untuk reporting',
            'endpoint' => 'analytics-export',
            'data_source' => 'custom',
            'custom_query' => 'SELECT DATE(created_at) as date, COUNT(*) as visits, SUM(page_views) as total_views FROM analytics WHERE created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY) GROUP BY DATE(created_at)',
            'response_format' => 'csv',
            'response_fields' => '["date", "visits", "total_views"]',
            'default_filters' => '{}',
            'allowed_filters' => '["start_date", "end_date"]',
            'default_limit' => 100,
            'max_limit' => 1000,
            'enable_pagination' => 1,
            'rate_limit_per_minute' => 10,
            'rate_limit_per_hour' => 100,
            'enable_cors' => 0,
            'cors_origins' => '[]',
            'enable_cache' => 1,
            'cache_duration' => 3600,
            'cache_key_prefix' => 'analytics_export',
            'require_token' => 1,
            'is_active' => 1,
            'total_requests' => 156,
            'total_success' => 152,
            'total_errors' => 4,
            'avg_response_time' => 0.567,
            'created_by' => 1,
            'created_at' => date('Y-m-d H:i:s', strtotime('-1 week')),
            'updated_at' => date('Y-m-d H:i:s', strtotime('-2 days'))
        ],
        [
            'name' => 'Public API Status',
            'description' => 'Endpoint publik untuk mengecek status sistem dan API health',
            'endpoint' => 'status',
            'data_source' => 'custom',
            'custom_query' => 'SELECT "online" as status, NOW() as timestamp, COUNT(*) as active_connections FROM information_schema.processlist',
            'response_format' => 'json',
            'response_fields' => '["status", "timestamp", "active_connections"]',
            'default_filters' => '{}',
            'allowed_filters' => '[]',
            'default_limit' => 1,
            'max_limit' => 1,
            'enable_pagination' => 0,
            'rate_limit_per_minute' => 300,
            'rate_limit_per_hour' => 5000,
            'enable_cors' => 1,
            'cors_origins' => '["*"]',
            'enable_cache' => 1,
            'cache_duration' => 60,
            'cache_key_prefix' => 'status_api',
            'require_token' => 0,
            'is_active' => 1,
            'total_requests' => 15678,
            'total_success' => 15654,
            'total_errors' => 24,
            'avg_response_time' => 0.023,
            'created_by' => 1,
            'created_at' => date('Y-m-d H:i:s', strtotime('-2 weeks')),
            'updated_at' => date('Y-m-d H:i:s', strtotime('-1 hour'))
        ]
    ];
    
    $insertSQL = "
    INSERT INTO get_only_receivers (
        name, description, endpoint, data_source, source_table, source_api_url, source_api_headers,
        custom_query, response_format, response_fields, default_filters, allowed_filters,
        default_limit, max_limit, enable_pagination, rate_limit_per_minute, rate_limit_per_hour,
        enable_cors, cors_origins, enable_cache, cache_duration, cache_key_prefix,
        require_token, is_active, total_requests, total_success, total_errors,
        avg_response_time, created_by, created_at, updated_at
    ) VALUES (
        :name, :description, :endpoint, :data_source, :source_table, :source_api_url, :source_api_headers,
        :custom_query, :response_format, :response_fields, :default_filters, :allowed_filters,
        :default_limit, :max_limit, :enable_pagination, :rate_limit_per_minute, :rate_limit_per_hour,
        :enable_cors, :cors_origins, :enable_cache, :cache_duration, :cache_key_prefix,
        :require_token, :is_active, :total_requests, :total_success, :total_errors,
        :avg_response_time, :created_by, :created_at, :updated_at
    )
    ";
    
    $stmt = $pdo->prepare($insertSQL);
    
    foreach ($sampleData as $index => $data) {
        $stmt->execute($data);
        echo "✅ Sample data " . ($index + 1) . " inserted: " . $data['name'] . "\n";
    }
    
    echo "\n📊 Summary:\n";
    echo "✅ Table created: get_only_receivers\n";
    echo "✅ Migration record added\n";
    echo "✅ Sample data inserted: " . count($sampleData) . " records\n";
    echo "\n🎉 GET-Only Receivers data berhasil dibuat!\n";
    echo "\n🔗 Test di: https://copilotproduction.site/get-only-receivers\n";
    
    // Show sample endpoints
    echo "\n📋 Sample Endpoints:\n";
    foreach ($sampleData as $data) {
        echo "• https://copilotproduction.site/api/get/" . $data['endpoint'] . "\n";
    }
    
} catch (PDOException $e) {
    echo "❌ Database error: " . $e->getMessage() . "\n";
    echo "\n📝 Manual SQL untuk membuat table:\n";
    echo "Copy SQL berikut ke phpMyAdmin:\n\n";
    
    echo "CREATE TABLE get_only_receivers (\n";
    echo "    id bigint(20) unsigned NOT NULL AUTO_INCREMENT,\n";
    echo "    name varchar(255) NOT NULL,\n";
    echo "    description text DEFAULT NULL,\n";
    echo "    endpoint varchar(255) NOT NULL,\n";
    echo "    data_source enum('table','api','custom') NOT NULL,\n";
    echo "    source_table varchar(255) DEFAULT NULL,\n";
    echo "    source_api_url varchar(500) DEFAULT NULL,\n";
    echo "    source_api_headers json DEFAULT NULL,\n";
    echo "    custom_query text DEFAULT NULL,\n";
    echo "    api_token_id bigint(20) unsigned DEFAULT NULL,\n";
    echo "    require_token tinyint(1) NOT NULL DEFAULT 0,\n";
    echo "    allowed_tokens json DEFAULT NULL,\n";
    echo "    response_format enum('json','xml','csv') NOT NULL DEFAULT 'json',\n";
    echo "    response_fields json DEFAULT NULL,\n";
    echo "    default_filters json DEFAULT NULL,\n";
    echo "    allowed_filters json DEFAULT NULL,\n";
    echo "    default_limit int(11) NOT NULL DEFAULT 50,\n";
    echo "    max_limit int(11) NOT NULL DEFAULT 1000,\n";
    echo "    enable_pagination tinyint(1) NOT NULL DEFAULT 1,\n";
    echo "    rate_limit_per_minute int(11) NOT NULL DEFAULT 60,\n";
    echo "    rate_limit_per_hour int(11) NOT NULL DEFAULT 1000,\n";
    echo "    allowed_ips json DEFAULT NULL,\n";
    echo "    enable_cors tinyint(1) NOT NULL DEFAULT 1,\n";
    echo "    cors_origins json DEFAULT NULL,\n";
    echo "    enable_cache tinyint(1) NOT NULL DEFAULT 1,\n";
    echo "    cache_duration int(11) NOT NULL DEFAULT 300,\n";
    echo "    cache_key_prefix varchar(100) DEFAULT NULL,\n";
    echo "    validation_rules json DEFAULT NULL,\n";
    echo "    required_parameters json DEFAULT NULL,\n";
    echo "    optional_parameters json DEFAULT NULL,\n";
    echo "    is_active tinyint(1) NOT NULL DEFAULT 1,\n";
    echo "    total_requests int(11) NOT NULL DEFAULT 0,\n";
    echo "    total_success int(11) NOT NULL DEFAULT 0,\n";
    echo "    total_errors int(11) NOT NULL DEFAULT 0,\n";
    echo "    last_accessed_at timestamp NULL DEFAULT NULL,\n";
    echo "    avg_response_time decimal(8,3) DEFAULT NULL,\n";
    echo "    metadata json DEFAULT NULL,\n";
    echo "    created_by bigint(20) unsigned DEFAULT NULL,\n";
    echo "    created_at timestamp NULL DEFAULT NULL,\n";
    echo "    updated_at timestamp NULL DEFAULT NULL,\n";
    echo "    PRIMARY KEY (id),\n";
    echo "    UNIQUE KEY get_only_receivers_endpoint_unique (endpoint)\n";
    echo ") ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
} 