<?php

/**
 * Script untuk membuat table get_only_receivers secara manual
 * Digunakan ketika ada masalah koneksi database dengan Laravel
 */

echo "=== Create GET-Only Receivers Table ===\n\n";

// Database configuration
$dbConfig = [
    'host' => '127.0.0.1',
    'database' => 'copg1493_api',
    'username' => 'copg1493_api',
    'password' => 'P7H_s;Aco25Vv??J'
];

try {
    $pdo = new PDO(
        "mysql:host={$dbConfig['host']};dbname={$dbConfig['database']}", 
        $dbConfig['username'], 
        $dbConfig['password']
    );
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "✅ Database connection successful\n\n";
} catch (PDOException $e) {
    echo "❌ Database connection failed: " . $e->getMessage() . "\n";
    echo "\n📝 Manual SQL untuk membuat table:\n\n";
    
    // Output SQL untuk copy-paste manual
    $sql = getCreateTableSQL();
    echo $sql . "\n\n";
    
    echo "📋 Cara menggunakan:\n";
    echo "1. Copy SQL di atas\n";
    echo "2. Buka phpMyAdmin atau tool database lainnya\n";
    echo "3. Pilih database 'copg1493_api'\n";
    echo "4. Jalankan SQL tersebut\n";
    exit(1);
}

// Check if table already exists
try {
    $stmt = $pdo->query("SHOW TABLES LIKE 'get_only_receivers'");
    if ($stmt->rowCount() > 0) {
        echo "⚠️  Table 'get_only_receivers' already exists\n";
        
        // Show table structure
        $stmt = $pdo->query("DESCRIBE get_only_receivers");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "\n📊 Current table structure:\n";
        foreach ($columns as $column) {
            echo "   - {$column['Field']}: {$column['Type']}\n";
        }
        
        echo "\n✅ Table is ready for use!\n";
        exit(0);
    }
} catch (PDOException $e) {
    echo "❌ Error checking table: " . $e->getMessage() . "\n";
}

// Create table
echo "📋 Creating 'get_only_receivers' table...\n";

try {
    $sql = getCreateTableSQL();
    $pdo->exec($sql);
    echo "✅ Table 'get_only_receivers' created successfully!\n";
    
    // Insert migration record
    try {
        $stmt = $pdo->prepare("INSERT INTO migrations (migration, batch) VALUES (?, ?)");
        $stmt->execute(['2025_07_05_104252_create_get_only_receivers_table', 1]);
        echo "✅ Migration record added\n";
    } catch (PDOException $e) {
        echo "⚠️  Could not add migration record: " . $e->getMessage() . "\n";
    }
    
    // Verify table creation
    $stmt = $pdo->query("DESCRIBE get_only_receivers");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "\n📊 Created table structure:\n";
    foreach ($columns as $column) {
        echo "   - {$column['Field']}: {$column['Type']}\n";
    }
    
    echo "\n🎉 GET-Only Receivers table is ready!\n";
    echo "\n🔗 You can now visit: https://copilotproduction.site/get-only-receivers\n";
    
} catch (PDOException $e) {
    echo "❌ Error creating table: " . $e->getMessage() . "\n";
    echo "\n📝 Manual SQL:\n\n";
    echo getCreateTableSQL() . "\n";
}

function getCreateTableSQL() {
    return "
CREATE TABLE get_only_receivers (
    id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    name varchar(255) NOT NULL COMMENT 'Descriptive name for the receiver',
    description text DEFAULT NULL COMMENT 'Optional description',
    endpoint varchar(255) NOT NULL COMMENT 'URL endpoint (alphanumeric, dash, underscore only)',
    data_source enum('table','api','custom') NOT NULL COMMENT 'Source of data: database table, external API, or custom query',
    source_table varchar(255) DEFAULT NULL COMMENT 'Database table name (if data_source is table)',
    source_api_url varchar(500) DEFAULT NULL COMMENT 'External API URL (if data_source is api)',
    source_api_headers json DEFAULT NULL COMMENT 'Headers for external API requests',
    custom_query text DEFAULT NULL COMMENT 'Custom SQL query (if data_source is custom)',
    api_token_id bigint(20) unsigned DEFAULT NULL COMMENT 'Associated API token for authentication',
    require_token tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Whether authentication is required',
    allowed_tokens json DEFAULT NULL COMMENT 'List of allowed token IDs',
    response_format enum('json','xml','csv') NOT NULL DEFAULT 'json' COMMENT 'Response format',
    response_fields json DEFAULT NULL COMMENT 'Fields to include in response',
    default_filters json DEFAULT NULL COMMENT 'Default filters to apply',
    allowed_filters json DEFAULT NULL COMMENT 'Allowed filter parameters',
    default_limit int(11) NOT NULL DEFAULT 50 COMMENT 'Default number of records to return',
    max_limit int(11) NOT NULL DEFAULT 1000 COMMENT 'Maximum allowed limit',
    enable_pagination tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Whether to enable pagination',
    rate_limit_per_minute int(11) NOT NULL DEFAULT 60 COMMENT 'Rate limit per minute',
    rate_limit_per_hour int(11) NOT NULL DEFAULT 1000 COMMENT 'Rate limit per hour',
    allowed_ips json DEFAULT NULL COMMENT 'IP whitelist',
    enable_cors tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Enable CORS headers',
    cors_origins json DEFAULT NULL COMMENT 'Allowed CORS origins',
    enable_cache tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Enable response caching',
    cache_duration int(11) NOT NULL DEFAULT 300 COMMENT 'Cache duration in seconds',
    cache_key_prefix varchar(100) DEFAULT NULL COMMENT 'Cache key prefix',
    validation_rules json DEFAULT NULL COMMENT 'Validation rules for parameters',
    required_parameters json DEFAULT NULL COMMENT 'Required query parameters',
    optional_parameters json DEFAULT NULL COMMENT 'Optional query parameters',
    is_active tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Whether the receiver is active',
    total_requests int(11) NOT NULL DEFAULT 0 COMMENT 'Total number of requests received',
    total_success int(11) NOT NULL DEFAULT 0 COMMENT 'Total successful responses',
    total_errors int(11) NOT NULL DEFAULT 0 COMMENT 'Total error responses',
    last_accessed_at timestamp NULL DEFAULT NULL COMMENT 'Last time the receiver was accessed',
    avg_response_time decimal(8,3) DEFAULT NULL COMMENT 'Average response time in seconds',
    metadata json DEFAULT NULL COMMENT 'Additional metadata',
    created_by bigint(20) unsigned DEFAULT NULL COMMENT 'User who created this receiver',
    created_at timestamp NULL DEFAULT NULL,
    updated_at timestamp NULL DEFAULT NULL,
    PRIMARY KEY (id),
    UNIQUE KEY get_only_receivers_endpoint_unique (endpoint),
    KEY get_only_receivers_api_token_id_foreign (api_token_id),
    KEY get_only_receivers_created_by_foreign (created_by),
    KEY get_only_receivers_data_source_index (data_source),
    KEY get_only_receivers_is_active_index (is_active),
    KEY get_only_receivers_response_format_index (response_format)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='GET-only API receivers for providing data endpoints';
";
}

?> 