<?php
// Create missing tables for POST-Only Receivers
echo "<h2>🗄️ Creating Missing Tables for POST-Only Receivers</h2>";

try {
    // Step 1: Check current database connection
    echo "<h3>Step 1: Testing Database Connection</h3>";
    
    $dbTest = shell_exec('php artisan tinker --execute="echo DB::connection()->getPdo() ? \'Connected\' : \'Failed\';" 2>&1');
    if (strpos($dbTest, 'Connected') !== false) {
        echo "<p style='color: green;'>✅ Database connection: OK</p>";
    } else {
        echo "<p style='color: red;'>❌ Database connection failed: $dbTest</p>";
        throw new Exception("Database connection failed");
    }
    
    // Step 2: Check if migrations exist
    echo "<h3>Step 2: Checking Migration Files</h3>";
    
    $migrations = [
        'database/migrations/2025_01_23_000001_create_post_only_receivers_table.php' => 'POST-Only Receivers Table',
        'database/migrations/2025_01_23_000002_create_post_only_receive_logs_table.php' => 'POST-Only Receive Logs Table'
    ];
    
    foreach ($migrations as $file => $name) {
        if (file_exists(__DIR__ . '/' . $file)) {
            echo "<p style='color: green;'>✅ <strong>$name:</strong> Migration file exists</p>";
        } else {
            echo "<p style='color: red;'>❌ <strong>$name:</strong> Migration file missing</p>";
        }
    }
    
    // Step 3: Check if tables already exist
    echo "<h3>Step 3: Checking Current Tables</h3>";
    
    $tables = ['post_only_receivers', 'post_only_receive_logs'];
    
    foreach ($tables as $table) {
        $tableCheck = shell_exec("php artisan tinker --execute=\"echo Schema::hasTable('$table') ? 'EXISTS' : 'NOT_EXISTS';\" 2>&1");
        if (strpos($tableCheck, 'EXISTS') !== false) {
            echo "<p style='color: green;'>✅ Table <strong>$table:</strong> Already exists</p>";
        } else {
            echo "<p style='color: orange;'>⚠️ Table <strong>$table:</strong> Does not exist</p>";
        }
    }
    
    // Step 4: Run migrations
    echo "<h3>Step 4: Running Migrations</h3>";
    
    // First, check migration status
    $migrationStatus = shell_exec('php artisan migrate:status 2>&1');
    echo "<p><strong>Migration Status:</strong></p>";
    echo "<pre style='background: #f8f9fa; padding: 10px; border-radius: 4px; max-height: 200px; overflow-y: auto;'>$migrationStatus</pre>";
    
    // Run migrations
    $migrationResult = shell_exec('php artisan migrate --force 2>&1');
    echo "<p><strong>Migration Result:</strong></p>";
    echo "<pre style='background: #f8f9fa; padding: 10px; border-radius: 4px; max-height: 200px; overflow-y: auto;'>$migrationResult</pre>";
    
    if (strpos($migrationResult, 'Migrated') !== false || strpos($migrationResult, 'Nothing to migrate') !== false) {
        echo "<p style='color: green;'>✅ Migrations completed successfully</p>";
    } else {
        echo "<p style='color: red;'>❌ Migration may have failed</p>";
    }
    
    // Step 5: Verify tables were created
    echo "<h3>Step 5: Verifying Table Creation</h3>";
    
    foreach ($tables as $table) {
        $tableCheck = shell_exec("php artisan tinker --execute=\"echo Schema::hasTable('$table') ? 'EXISTS' : 'NOT_EXISTS';\" 2>&1");
        if (strpos($tableCheck, 'EXISTS') !== false) {
            echo "<p style='color: green;'>✅ Table <strong>$table:</strong> Successfully created</p>";
            
            // Check table structure
            $tableInfo = shell_exec("php artisan tinker --execute=\"echo json_encode(Schema::getColumnListing('$table'));\" 2>&1");
            if ($tableInfo) {
                echo "<p><strong>Columns in $table:</strong> $tableInfo</p>";
            }
        } else {
            echo "<p style='color: red;'>❌ Table <strong>$table:</strong> Still does not exist</p>";
        }
    }
    
    // Step 6: Test PostOnlyReceiver model
    echo "<h3>Step 6: Testing PostOnlyReceiver Model</h3>";
    
    $modelTest = shell_exec('php artisan tinker --execute="echo \\App\\Models\\PostOnlyReceiver::count();" 2>&1');
    if (is_numeric(trim($modelTest))) {
        echo "<p style='color: green;'>✅ PostOnlyReceiver model working (Records: " . trim($modelTest) . ")</p>";
    } else {
        echo "<p style='color: red;'>❌ PostOnlyReceiver model test failed: $modelTest</p>";
    }
    
    echo "<hr>";
    echo "<h3 style='color: blue;'>🎯 Summary</h3>";
    echo "<p>Database migration process completed.</p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h3>📋 Next Steps:</h3>";
echo "<ol>";
echo "<li>Try accessing the POST-Only Receivers page again</li>";
echo "<li>If still getting table errors, check database permissions</li>";
echo "<li>Verify database connection settings in .env file</li>";
echo "<li>Check Laravel logs for detailed error information</li>";
echo "</ol>";

echo "<p><strong>Table creation completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?> 