<?php

// Script untuk membuat POST-Only Receiver untuk endpoint 'modern-receiver-568'
require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\PostOnlyReceiver;
use App\Models\ApiClient;

echo "=== Creating Modern Receiver ===\n";

try {
    // Check if receiver already exists
    $existingReceiver = PostOnlyReceiver::where('endpoint', 'modern-receiver-568')->first();
    
    if ($existingReceiver) {
        echo "✅ Receiver already exists:\n";
        echo "  - ID: {$existingReceiver->id}\n";
        echo "  - Name: {$existingReceiver->name}\n";
        echo "  - Endpoint: {$existingReceiver->endpoint}\n";
        echo "  - Target Table: {$existingReceiver->target_table}\n";
        echo "  - Is Active: " . ($existingReceiver->is_active ? 'Yes' : 'No') . "\n";
        echo "  - Require Token: " . ($existingReceiver->require_token ? 'Yes' : 'No') . "\n";
        
        if (!$existingReceiver->is_active) {
            echo "⚠️  Receiver is not active. Activating...\n";
            $existingReceiver->update(['is_active' => true]);
            echo "✅ Receiver activated\n";
        }
    } else {
        echo "📝 Creating new receiver for 'modern-receiver-568'...\n";
        
        // Get first API client (optional)
        $apiClient = ApiClient::where('is_active', true)->first();
        
        $receiver = PostOnlyReceiver::create([
            'name' => 'Modern Receiver Test',
            'endpoint' => 'modern-receiver-568',
            'target_table' => 'modern_receiver_data',
            'description' => 'Auto-created receiver for testing modern-receiver-568 endpoint',
            'api_client_id' => $apiClient ? $apiClient->id : null,
            'require_token' => false, // No token required for easy testing
            'auto_create_table' => true,
            'is_active' => true,
            'rate_limit' => 1000,
            'sample_data' => [
                'user_id' => 123,
                'event_type' => 'test_event',
                'data' => [
                    'message' => 'Test message',
                    'timestamp' => '2025-01-23T10:30:00Z'
                ],
                'source' => 'modern_receiver'
            ]
        ]);
        
        echo "✅ Receiver created successfully:\n";
        echo "  - ID: {$receiver->id}\n";
        echo "  - Name: {$receiver->name}\n";
        echo "  - Endpoint: {$receiver->endpoint}\n";
        echo "  - Target Table: {$receiver->target_table}\n";
        echo "  - API Client: " . ($receiver->apiClient ? $receiver->apiClient->name : 'None') . "\n";
    }
    
    echo "\n=== Testing Information ===\n";
    echo "URL: https://copilotproduction.site/api/post/modern-receiver-568\n";
    echo "Method: POST\n";
    echo "Token Required: No\n";
    echo "Content-Type: application/json\n";
    echo "\nSample curl command:\n";
    echo "curl -X POST https://copilotproduction.site/api/post/modern-receiver-568 \\\n";
    echo "  -H \"Content-Type: application/json\" \\\n";
    echo "  -d '{\"user_id\": 123, \"event_type\": \"test\", \"message\": \"Hello World\"}'\n";
    
} catch (\Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
}

echo "\n=== Done ===\n"; 