<?php
// Create sample webhook receiver if it doesn't exist
header('Content-Type: text/plain');

// Database connection
$host = 'localhost';
$database = 'copg1493_api';
$username = 'copg1493';
$password = 'wPD6DDSegDHd56';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "=== Creating Sample Webhook Receiver ===\n\n";
    
    // Check if post_only_receivers table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'post_only_receivers'");
    if ($stmt->rowCount() == 0) {
        echo "❌ Table 'post_only_receivers' does not exist!\n";
        echo "Please run: https://copilotproduction.site/run-sql-script.php first\n";
        exit;
    }
    
    // Check if sample-webhook already exists
    $stmt = $pdo->prepare("SELECT id FROM post_only_receivers WHERE endpoint = ?");
    $stmt->execute(['sample-webhook']);
    if ($stmt->rowCount() > 0) {
        echo "✅ Receiver 'sample-webhook' already exists!\n";
        echo "Visit: https://copilotproduction.site/check-receiver-endpoint.php for details\n";
        exit;
    }
    
    // Get or create an API client
    $stmt = $pdo->query("SELECT id FROM api_clients WHERE is_active = 1 LIMIT 1");
    $apiClient = $stmt->fetch(PDO::FETCH_ASSOC);
    $apiClientId = $apiClient ? $apiClient['id'] : null;
    
    if (!$apiClientId) {
        echo "Creating default API client...\n";
        $stmt = $pdo->prepare("INSERT INTO api_clients (name, description, is_active, created_at, updated_at) VALUES (?, ?, 1, NOW(), NOW())");
        $stmt->execute(['Default Client', 'Default API client for testing']);
        $apiClientId = $pdo->lastInsertId();
        echo "✅ Created API client with ID: $apiClientId\n";
    }
    
    // Create sample webhook receiver
    $stmt = $pdo->prepare("
        INSERT INTO post_only_receivers (
            name, 
            description, 
            endpoint, 
            target_table, 
            api_client_id, 
            require_token, 
            field_mapping, 
            validation_rules, 
            auto_create_table, 
            is_active, 
            created_at, 
            updated_at
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())
    ");
    
    $fieldMapping = json_encode([
        'name' => 'name',
        'email' => 'email',
        'message' => 'message',
        'timestamp' => 'created_at'
    ]);
    
    $validationRules = json_encode([
        'name' => 'required|string|max:255',
        'email' => 'required|email',
        'message' => 'required|string'
    ]);
    
    $stmt->execute([
        'Sample Webhook',
        'Sample webhook receiver for testing POST requests',
        'sample-webhook',
        'webhook_data',
        $apiClientId,
        0, // Don't require token for testing
        $fieldMapping,
        $validationRules,
        1, // Auto create table
        1  // Active
    ]);
    
    $receiverId = $pdo->lastInsertId();
    echo "✅ Created sample webhook receiver with ID: $receiverId\n";
    
    // Create target table
    echo "Creating target table 'webhook_data'...\n";
    $createTable = "
        CREATE TABLE IF NOT EXISTS webhook_data (
            id INT AUTO_INCREMENT PRIMARY KEY,
            name VARCHAR(255) NOT NULL,
            email VARCHAR(255) NOT NULL,
            message TEXT NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )
    ";
    $pdo->exec($createTable);
    echo "✅ Created target table 'webhook_data'\n";
    
    echo "\n=== Sample Receiver Created Successfully! ===\n";
    echo "Endpoint: sample-webhook\n";
    echo "Full URL: https://copilotproduction.site/api/post/sample-webhook\n";
    echo "Method: POST\n";
    echo "Token Required: No\n";
    echo "Target Table: webhook_data\n";
    echo "\n=== Test with cURL ===\n";
    echo "curl -X POST https://copilotproduction.site/api/post/sample-webhook \\\n";
    echo "  -H \"Content-Type: application/json\" \\\n";
    echo "  -d '{\"name\":\"John Doe\",\"email\":\"john@example.com\",\"message\":\"Test message\"}'\n";
    echo "\n=== Management URLs ===\n";
    echo "View receiver: https://copilotproduction.site/post-only-receivers\n";
    echo "Check status: https://copilotproduction.site/check-receiver-endpoint.php\n";
    
} catch (PDOException $e) {
    echo "❌ Database error: " . $e->getMessage() . "\n";
    echo "Please check database connection and run the table creation script first.\n";
}
?> 