<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\ApiReceiver;

try {
    // Check if receiver already exists
    $existingReceiver = ApiReceiver::where('endpoint', 'baden')->first();
    
    if ($existingReceiver) {
        echo "Receiver dengan endpoint 'baden' sudah ada:\n";
        echo "ID: {$existingReceiver->id}\n";
        echo "Name: {$existingReceiver->name}\n";
        echo "Auth Type: {$existingReceiver->auth_type}\n";
        echo "Auth Username: {$existingReceiver->auth_username}\n";
        echo "Auth Password: {$existingReceiver->auth_password}\n";
        echo "Is Active: " . ($existingReceiver->is_active ? 'Yes' : 'No') . "\n";
        
        // Update to Basic Auth if needed
        if ($existingReceiver->auth_type !== 'basic_auth') {
            $existingReceiver->update([
                'auth_type' => 'basic_auth',
                'auth_username' => 'baden',
                'auth_password' => 'baden',
                'is_active' => true
            ]);
            echo "\nReceiver berhasil diupdate ke Basic Auth!\n";
        }
    } else {
        // Create new receiver
        $receiver = ApiReceiver::create([
            'name' => 'Baden Basic Auth Receiver',
            'description' => 'Receiver for Baden System with Basic Authentication',
            'endpoint' => 'baden',
            'target_table' => 'orders',
            'auth_type' => 'basic_auth',
            'auth_username' => 'baden',
            'auth_password' => 'baden',
            'allowed_methods' => 'GET,POST,PUT,DELETE',
            'rate_limit' => 100,
            'auto_create_table' => true,
            'is_active' => true,
            'is_bidirectional' => true,
            'duplicate_handling' => 'update',
            'unique_fields' => 'order_id',
            'data_filter' => 'all',
            'max_records_per_request' => 100,
            'enable_scheduling' => true,
            'schedule_type' => 'interval',
            'schedule_interval' => 5,
            'timezone' => 'Asia/Jakarta',
            'response_format' => 'json',
            'auto_acknowledge' => true,
            'retry_attempts' => 3,
            'retry_delay' => 60,
            'validation_rules' => json_encode([
                'order_id' => ['required' => true, 'type' => 'string'],
                'customer_name' => ['required' => true, 'type' => 'string'],
                'total_amount' => ['required' => true, 'type' => 'numeric']
            ])
        ]);
        
        echo "Receiver berhasil dibuat!\n";
        echo "ID: {$receiver->id}\n";
        echo "Endpoint: /api/in/{$receiver->endpoint}\n";
        echo "Username: {$receiver->auth_username}\n";
        echo "Password: {$receiver->auth_password}\n";
        echo "Basic Auth Header: Basic " . base64_encode($receiver->auth_username . ':' . $receiver->auth_password) . "\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}
