-- Create POST-Only Receivers Database Tables
-- Database: copg1493_api

USE copg1493_api;

-- Create post_only_receivers table
CREATE TABLE IF NOT EXISTS `post_only_receivers` (
    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `name` varchar(255) NOT NULL COMMENT 'Nama receiver yang mudah dibaca',
    `endpoint` varchar(255) NOT NULL COMMENT 'URL path endpoint (contoh: webhook-data)',
    `target_table` varchar(255) NOT NULL COMMENT 'Nama tabel tujuan penyimpanan data',
    `description` text DEFAULT NULL COMMENT 'Deskripsi receiver',
    `api_client_id` bigint(20) unsigned DEFAULT NULL COMMENT 'ID API client yang terkait',
    `require_token` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Apakah memerlukan token untuk akses',
    `field_mapping` json DEFAULT NULL COMMENT 'Mapping field dari request ke database',
    `validation_rules` json DEFAULT NULL COMMENT 'Aturan validasi untuk data POST',
    `auto_create_table` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Auto create table dari sample data',
    `allowed_ips` json DEFAULT NULL COMMENT 'IP whitelist (JSON array)',
    `rate_limit` int(11) NOT NULL DEFAULT 1000 COMMENT 'Requests per hour limit',
    `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Status aktif receiver',
    `last_received_at` timestamp NULL DEFAULT NULL COMMENT 'Waktu terakhir menerima data',
    `total_received` int(11) NOT NULL DEFAULT 0 COMMENT 'Total data yang diterima',
    `total_success` int(11) NOT NULL DEFAULT 0 COMMENT 'Total data berhasil diproses',
    `total_failed` int(11) NOT NULL DEFAULT 0 COMMENT 'Total data gagal diproses',
    `sample_data` json DEFAULT NULL COMMENT 'Contoh data untuk dokumentasi',
    `created_at` timestamp NULL DEFAULT NULL,
    `updated_at` timestamp NULL DEFAULT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `post_only_receivers_endpoint_unique` (`endpoint`),
    KEY `post_only_receivers_endpoint_is_active_index` (`endpoint`,`is_active`),
    KEY `post_only_receivers_api_client_id_index` (`api_client_id`),
    KEY `post_only_receivers_target_table_index` (`target_table`),
    KEY `post_only_receivers_require_token_index` (`require_token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Create post_only_receive_logs table
CREATE TABLE IF NOT EXISTS `post_only_receive_logs` (
    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `receiver_id` bigint(20) unsigned NOT NULL,
    `ip_address` varchar(45) DEFAULT NULL,
    `user_agent` text DEFAULT NULL,
    `headers` json DEFAULT NULL,
    `body` longtext DEFAULT NULL,
    `status_code` int(11) NOT NULL,
    `response_message` text DEFAULT NULL,
    `response_time` decimal(8,3) DEFAULT NULL COMMENT 'Response time in seconds',
    `payload_size` int(11) DEFAULT NULL COMMENT 'Payload size in bytes',
    `token_valid` tinyint(1) NOT NULL DEFAULT 0,
    `validation_success` tinyint(1) NOT NULL DEFAULT 0,
    `validation_errors` json DEFAULT NULL,
    `saved_to_table` tinyint(1) NOT NULL DEFAULT 0,
    `save_error` text DEFAULT NULL,
    `client_id` bigint(20) unsigned DEFAULT NULL,
    `token_id` bigint(20) unsigned DEFAULT NULL,
    `created_at` timestamp NULL DEFAULT NULL,
    `updated_at` timestamp NULL DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `post_only_receive_logs_receiver_id_created_at_index` (`receiver_id`,`created_at`),
    KEY `post_only_receive_logs_status_code_index` (`status_code`),
    KEY `post_only_receive_logs_token_valid_index` (`token_valid`),
    KEY `post_only_receive_logs_validation_success_index` (`validation_success`),
    KEY `post_only_receive_logs_saved_to_table_index` (`saved_to_table`),
    CONSTRAINT `post_only_receive_logs_receiver_id_foreign` FOREIGN KEY (`receiver_id`) REFERENCES `post_only_receivers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert sample data for testing
INSERT INTO `post_only_receivers` (`name`, `endpoint`, `target_table`, `description`, `require_token`, `is_active`, `created_at`, `updated_at`) VALUES
('Sample Webhook Receiver', 'sample-webhook', 'webhook_data', 'Sample receiver for testing webhook functionality', 0, 1, NOW(), NOW()),
('API Data Receiver', 'api-data-receiver', 'api_received_data', 'Receiver for general API data posting', 1, 1, NOW(), NOW());

-- Show created tables
SHOW TABLES LIKE 'post_only_%';

-- Show table structures
DESCRIBE post_only_receivers;
DESCRIBE post_only_receive_logs;

-- Test table access
SELECT COUNT(*) as total_receivers FROM post_only_receivers;
SELECT COUNT(*) as total_logs FROM post_only_receive_logs; 