<?php

/**
 * Script untuk membuat API Target test
 * Jalankan dengan: php create_test_target.php
 */

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\ApiTarget;
use App\Models\User;

echo "=== MEMBUAT API TARGET TEST ===\n\n";

try {
    // Ambil user pertama
    $user = User::first();
    if (!$user) {
        echo "❌ Tidak ada user di database. Jalankan seeder dulu.\n";
        exit(1);
    }
    
    echo "✓ User ditemukan: {$user->name} ({$user->email})\n";
    
    // Buat API Target test
    $apiTarget = ApiTarget::create([
        'name' => 'Test API Target',
        'description' => 'API Target untuk testing fitur pengiriman data',
        'base_url' => 'https://httpbin.org',
        'endpoint' => '/post',
        'method' => 'POST',
        'source_table' => 'users',
        'auth_type' => 'none',
        'schedule_type' => 'manual',
        'is_active' => true,
        'created_by' => $user->id
    ]);
    
    echo "✓ API Target berhasil dibuat!\n";
    echo "  - ID: {$apiTarget->id}\n";
    echo "  - Nama: {$apiTarget->name}\n";
    echo "  - URL Lengkap: {$apiTarget->url}\n";
    echo "  - Method: {$apiTarget->method}\n";
    echo "  - Source Table: {$apiTarget->source_table}\n";
    echo "  - Status: " . ($apiTarget->is_active ? 'Active' : 'Inactive') . "\n\n";
    
    // Cek data di tabel users
    $userCount = User::count();
    echo "✓ Data di tabel 'users': {$userCount} records\n\n";
    
    echo "=== SELANJUTNYA ===\n";
    echo "1. Buka browser ke: http://127.0.0.1:8000/api-targets\n";
    echo "2. Login dengan user yang ada\n";
    echo "3. Klik 'Send Data' pada API Target yang baru dibuat\n";
    echo "4. Atau buka: http://127.0.0.1:8000/api-targets/{$apiTarget->id}\n\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
} 