<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // First check current enum values
        $enumValues = DB::select("SHOW COLUMNS FROM api_receivers WHERE Field = 'auth_type'")[0]->Type;
        
        // If basic_auth is not already in the enum, add it
        if (strpos($enumValues, 'basic_auth') === false) {
            // Modify the enum to include 'basic_auth'
            DB::statement("ALTER TABLE api_receivers MODIFY COLUMN auth_type ENUM('none', 'api_key', 'bearer_token', 'basic_auth', 'hmac_signature') DEFAULT 'none'");
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove 'basic_auth' from enum (only if no records use it)
        $hasBasicAuthRecords = DB::table('api_receivers')->where('auth_type', 'basic_auth')->exists();
        
        if (!$hasBasicAuthRecords) {
            DB::statement("ALTER TABLE api_receivers MODIFY COLUMN auth_type ENUM('none', 'api_key', 'bearer_token', 'hmac_signature') DEFAULT 'none'");
        } else {
            // Log warning instead of failing
            Log::warning('Cannot remove basic_auth from auth_type enum: records exist with this value');
        }
    }
};
