<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_clients', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Client name
            $table->string('client_id')->unique(); // Client ID
            $table->string('client_secret'); // Client secret
            $table->string('usertoken')->unique(); // User token for authentication
            $table->string('passtoken'); // Pass token for authentication
            $table->json('allowed_endpoints')->nullable(); // Restricted endpoints
            $table->json('allowed_ips')->nullable(); // IP whitelist
            $table->boolean('is_active')->default(true); // Active status
            $table->integer('rate_limit')->default(1000); // Requests per hour
            $table->text('description')->nullable(); // Description
            $table->timestamp('last_used_at')->nullable(); // Last usage
            $table->timestamp('expires_at')->nullable(); // Expiration date
            $table->timestamps();
            
            $table->index(['is_active']);
            $table->index(['client_id']);
            $table->index(['usertoken']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_clients');
    }
}; 