<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_tokens', function (Blueprint $table) {
            $table->id();
            $table->foreignId('api_client_id')->constrained()->cascadeOnDelete();
            $table->string('token', 128)->unique(); // Access token
            $table->string('refresh_token', 128)->unique(); // Refresh token
            $table->timestamp('expires_at')->nullable(); // Expiration time
            $table->string('scope')->default('default'); // Token scope/permissions
            $table->boolean('is_revoked')->default(false); // Revoked status
            $table->timestamp('last_used_at')->nullable(); // Last usage
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['token', 'is_revoked', 'expires_at']);
            $table->index(['api_client_id', 'is_revoked']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_tokens');
    }
}; 