<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_access_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('api_client_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('api_token_id')->nullable()->constrained()->nullOnDelete();
            $table->string('endpoint'); // API endpoint accessed
            $table->string('method', 10); // HTTP method
            $table->string('ip_address', 45); // IPv4/IPv6 address
            $table->text('user_agent')->nullable(); // User agent
            $table->json('request_headers')->nullable(); // Request headers
            $table->json('request_body')->nullable(); // Request body
            $table->integer('response_status'); // HTTP status code
            $table->integer('response_time'); // Response time in ms
            $table->json('response_body')->nullable(); // Response body
            $table->boolean('success')->default(false); // Success status
            $table->text('error_message')->nullable(); // Error message if failed
            $table->timestamp('accessed_at'); // Access timestamp
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['api_client_id', 'accessed_at']);
            $table->index(['endpoint', 'accessed_at']);
            $table->index(['success', 'accessed_at']);
            $table->index(['ip_address', 'accessed_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_access_logs');
    }
}; 