<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('data_backups', function (Blueprint $table) {
            $table->id();
            $table->string('backup_id')->unique()->index(); // Backup identifier
            $table->string('job_id')->nullable()->index(); // Related job ID
            $table->string('backup_type')->default('manual')->index(); // manual, scheduled, automatic
            $table->json('data'); // Backup data
            $table->text('description')->nullable(); // Backup description
            $table->integer('data_size')->default(0); // Size of data in bytes
            $table->integer('record_count')->default(0); // Number of records
            $table->enum('status', ['active', 'archived', 'deleted'])->default('active')->index();
            $table->timestamp('expires_at')->nullable(); // Expiration date
            $table->timestamps();

            // Indexes for performance
            $table->index(['backup_type', 'status']);
            $table->index(['status', 'created_at']);
            $table->index(['expires_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('data_backups');
    }
}; 