<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('job_results', function (Blueprint $table) {
            $table->id();
            $table->string('job_id')->index(); // Job identifier
            $table->string('job_type')->index(); // Type of job (process, transform, export, etc.)
            $table->json('result')->nullable(); // Job result data
            $table->text('error_message')->nullable(); // Error message if failed
            $table->text('error_trace')->nullable(); // Error stack trace
            $table->integer('processing_time_ms')->default(0); // Processing time in milliseconds
            $table->enum('status', ['completed', 'failed', 'cancelled'])->default('completed')->index();
            $table->integer('attempt')->default(1); // Attempt number
            $table->json('metadata')->nullable(); // Additional metadata
            $table->timestamps();

            // Indexes for performance
            $table->index(['job_type', 'status']);
            $table->index(['status', 'created_at']);
            $table->index(['job_type', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('job_results');
    }
}; 