<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wim_log', function (Blueprint $table) {
            $table->id();
            $table->string('id_wim'); // ID WIM yang terkait
            $table->string('no_kendaraan'); // Nomor kendaraan
            $table->string('jenis_kendaraan')->nullable(); // Jenis kendaraan
            $table->string('merk_kendaraan')->nullable(); // Merk kendaraan
            $table->string('model_kendaraan')->nullable(); // Model kendaraan
            $table->string('warna_kendaraan')->nullable(); // Warna kendaraan
            $table->string('tahun_kendaraan')->nullable(); // Tahun kendaraan
            $table->string('nomor_rangka')->nullable(); // Nomor rangka
            $table->string('nomor_mesin')->nullable(); // Nomor mesin
            $table->string('nama_pengemudi')->nullable(); // Nama pengemudi
            $table->string('nomor_sim')->nullable(); // Nomor SIM
            $table->string('alamat_pengemudi')->nullable(); // Alamat pengemudi
            $table->string('nama_perusahaan')->nullable(); // Nama perusahaan
            $table->string('alamat_perusahaan')->nullable(); // Alamat perusahaan
            $table->string('nomor_izin')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wim_log');
    }
};