<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wim_prasarana', function (Blueprint $table) {
            $table->id();
            $table->string('id_wim')->unique(); // ID WIM sesuai spesifikasi Hubnet
            $table->string('nama_lokasi'); // Nama lokasi WIM
            $table->string('tipe'); // Tipe prasarana WIM
            $table->string('dimensi'); // Dimensi prasarana
            $table->integer('tahun_pembuatan'); // Tahun pembuatan
            $table->string('kondisi')->nullable(); // Kondisi prasarana
            $table->text('keterangan')->nullable(); // Keterangan tambahan
            $table->string('status')->default('aktif'); // Status prasarana
            $table->decimal('latitude', 10, 8)->nullable(); // Koordinat latitude
            $table->decimal('longitude', 11, 8)->nullable(); // Koordinat longitude
            $table->string('alamat')->nullable(); // Alamat lokasi
            $table->string('provinsi')->nullable(); // Provinsi
            $table->string('kabupaten')->nullable(); // Kabupaten
            $table->string('kecamatan')->nullable(); // Kecamatan
            $table->string('desa')->nullable(); // Desa
            $table->string('kode_pos')->nullable(); // Kode pos
            $table->string('nomor_telepon')->nullable(); // Nomor telepon
            $table->string('email')->nullable(); // Email kontak
            $table->string('penanggung_jawab')->nullable(); // Penanggung jawab
            $table->boolean('is_sent_to_hubnet')->default(false); // Status pengiriman ke Hubnet
            $table->timestamp('sent_to_hubnet_at')->nullable(); // Waktu pengiriman ke Hubnet
            $table->timestamps();
            
            $table->index(['id_wim']);
            $table->index(['is_sent_to_hubnet']);
            $table->index(['status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wim_prasarana');
    }
}; 