<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('api_logs', function (Blueprint $table) {
            // Add api_source_id column with foreign key constraint
            $table->foreignId('api_source_id')->nullable()->after('id')->constrained('api_sources')->cascadeOnDelete();
            
            // Add missing columns that the model expects
            if (!Schema::hasColumn('api_logs', 'response_data')) {
                $table->longText('response_data')->nullable()->after('response_body');
            }
            
            if (!Schema::hasColumn('api_logs', 'error_message')) {
                $table->text('error_message')->nullable()->after('response_data');
            }
            
            // Add index for performance
            $table->index(['api_source_id', 'requested_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('api_logs', function (Blueprint $table) {
            // Drop indexes first
            $table->dropIndex(['api_source_id', 'requested_at']);
            
            // Drop foreign key constraint and column
            $table->dropForeign(['api_source_id']);
            $table->dropColumn(['api_source_id', 'response_data', 'error_message']);
        });
    }
}; 