<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('api_logs', function (Blueprint $table) {
            // Add status column (success/error)
            if (!Schema::hasColumn('api_logs', 'status')) {
                $table->enum('status', ['success', 'error', 'pending'])->default('pending')->after('status_code');
            }
            
            // Add records_imported column
            if (!Schema::hasColumn('api_logs', 'records_imported')) {
                $table->integer('records_imported')->default(0)->after('response_time');
            }
            
            // Add response_code column (alias for status_code for backward compatibility)
            if (!Schema::hasColumn('api_logs', 'response_code')) {
                $table->integer('response_code')->nullable()->after('status_code');
            }
            
            // Add indexes for performance
            $table->index(['status', 'created_at']);
            $table->index(['api_source_id', 'status']);
        });
        
        // Update existing records to set status based on status_code
        DB::statement("
            UPDATE api_logs 
            SET status = CASE 
                WHEN status_code >= 200 AND status_code < 300 THEN 'success'
                WHEN status_code = 0 OR error_message IS NOT NULL THEN 'error'
                ELSE 'pending'
            END,
            response_code = status_code
            WHERE status = 'pending'
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('api_logs', function (Blueprint $table) {
            // Drop indexes first
            $table->dropIndex(['status', 'created_at']);
            $table->dropIndex(['api_source_id', 'status']);
            
            // Drop columns
            $table->dropColumn(['status', 'records_imported', 'response_code']);
        });
    }
}; 