<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('post_only_receivers', function (Blueprint $table) {
            $table->id();
            $table->string('name')->comment('Nama receiver yang mudah dibaca');
            $table->string('endpoint')->unique()->comment('URL path endpoint (contoh: webhook-data)');
            $table->string('target_table')->comment('Nama tabel tujuan penyimpanan data');
            $table->text('description')->nullable()->comment('Deskripsi receiver');
            
            // API Token Integration
            $table->foreignId('api_client_id')->nullable()->constrained('api_clients')->onDelete('set null')
                ->comment('ID API client yang terkait');
            $table->boolean('require_token')->default(true)->comment('Apakah memerlukan token untuk akses');
            
            // Data Processing
            $table->json('field_mapping')->nullable()->comment('Mapping field dari request ke database');
            $table->json('validation_rules')->nullable()->comment('Aturan validasi untuk data POST');
            $table->boolean('auto_create_table')->default(false)->comment('Auto create table dari sample data');
            
            // Security & Rate Limiting
            $table->json('allowed_ips')->nullable()->comment('IP whitelist (JSON array)');
            $table->integer('rate_limit')->default(1000)->comment('Requests per hour limit');
            
            // Status & Monitoring
            $table->boolean('is_active')->default(true)->comment('Status aktif receiver');
            $table->timestamp('last_received_at')->nullable()->comment('Waktu terakhir menerima data');
            $table->integer('total_received')->default(0)->comment('Total data yang diterima');
            $table->integer('total_success')->default(0)->comment('Total data berhasil diproses');
            $table->integer('total_failed')->default(0)->comment('Total data gagal diproses');
            
            // Sample Data for Documentation
            $table->json('sample_data')->nullable()->comment('Contoh data untuk dokumentasi');
            
            $table->timestamps();
            
            // Indexes
            $table->index(['endpoint', 'is_active']);
            $table->index(['api_client_id']);
            $table->index(['target_table']);
            $table->index(['require_token']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('post_only_receivers');
    }
}; 