<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('post_only_receive_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('receiver_id')->constrained('post_only_receivers')->onDelete('cascade');
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->json('headers')->nullable();
            $table->longText('body')->nullable();
            $table->integer('status_code');
            $table->text('response_message')->nullable();
            $table->decimal('response_time', 8, 3)->nullable()->comment('Response time in seconds');
            $table->integer('payload_size')->nullable()->comment('Payload size in bytes');
            $table->boolean('token_valid')->default(false);
            $table->boolean('validation_success')->default(false);
            $table->json('validation_errors')->nullable();
            $table->boolean('saved_to_table')->default(false);
            $table->text('save_error')->nullable();
            $table->foreignId('client_id')->nullable()->constrained('api_clients')->onDelete('set null');
            $table->foreignId('token_id')->nullable()->constrained('api_tokens')->onDelete('set null');
            $table->timestamps();
            
            // Indexes
            $table->index(['receiver_id', 'created_at']);
            $table->index(['status_code']);
            $table->index(['token_valid']);
            $table->index(['validation_success']);
            $table->index(['saved_to_table']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('post_only_receive_logs');
    }
}; 