<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_sources', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique();
            $table->text('url');
            $table->string('auth_type')->default('none');
            $table->text('auth_token')->nullable();
            $table->string('table_name')->unique();
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->enum('schedule_type', ['manual', 'hourly', 'daily'])->default('manual');
            $table->integer('schedule_frequency')->nullable();
            $table->json('sample_data')->nullable();
            $table->timestamp('last_fetched_at')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
            
            // Add indexes for performance
            $table->index(['status', 'schedule_type']);
            $table->index('auth_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_sources');
    }
};
