<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_targets', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Nama target API
            $table->string('base_url'); // Base URL (e.g., https://api.example.com)
            $table->string('endpoint'); // Endpoint path (e.g., /webhook/data)
            $table->enum('method', ['GET', 'POST', 'PUT', 'PATCH', 'DELETE'])->default('POST'); // HTTP method
            $table->string('source_table'); // Source table for data
            $table->enum('auth_type', ['none', 'api_key', 'bearer_token', 'basic_auth'])->default('none');
            $table->string('auth_token')->nullable(); // API key, bearer token, etc.
            $table->string('auth_username')->nullable(); // For basic auth
            $table->string('auth_password')->nullable(); // For basic auth
            $table->json('headers')->nullable(); // Custom headers (Authorization, Content-Type, dll)
            $table->json('field_mapping')->nullable();
            $table->integer('timeout')->default(30); // Request timeout in seconds
            $table->boolean('is_active')->default(true); // Active status
            $table->text('description')->nullable(); // Description
            $table->string('callback_url')->nullable();
            $table->enum('callback_method', ['POST', 'PUT', 'PATCH'])->default('POST');
            $table->json('success_response_template')->nullable();
            $table->json('error_response_template')->nullable();
            $table->timestamp('last_sent_at')->nullable();
            $table->integer('total_forwarded')->default(0); // Total data forwarded
            $table->timestamps();
            
            $table->index(['is_active']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_targets');
    }
};
